# [``hNX
# Author:: fukuyama
# Date:: 2006/06/12
# Copyright:: Copyright (C) 2006,2007 rgss-lib

# [``hNX
class Rule_AI_Base < Battle_AI_Base
  
  # `h[NX
  class AI_Rule
    include Battle_AI_Adapter
    
    # [
    def rule_initialize
    end
    
    # [XRA
    def score
      return -1.0
    end
    
    # se
    def execute
    end
    
  end
  
  # `h[NX
  # XRAx[XiXRAŒj
  class AI_Rule_Score_Base < AI_Rule
    # XRA
    attr_reader :score
    
    # 
    def initialize(score)
      @score = score
      super()
    end
    def execute_condition
      return false
    end
    def score
      if execute_condition()
        return @score
      end
      super
    end
  end
  
  # `hNX̃\bhɃ[NX쐬
  class AI_Rule_Symbol_Method < AI_Rule
    # [XRA
    attr_writer :score_symbol
    # se
    attr_writer :execute_symbol
    
    # [XRA
    def score
      return @ai.method(@score_symbol).call
    end
    
    # se
    def execute
      return @ai.method(@execute_symbol).call
    end
  end
  
  # ANV쐬
  def make_action_initialize
    @rule_list.each do |rule|
      rule.rule_initialize
    end
  end
  
  # ANV쐬
  # Battle_AI_Base#make_action I[o[Ch
  def make_action
    make_action_initialize
    max_rule = nil
    max_score = -1.0
    for rule in @rule_list
      score = rule.score
      if max_score < score
        max_score = score
        max_rule = rule
      end
    end
    max_rule.execute
    clear
  end
  
  # AI_Rule ̍쐬
  # 1.
  # rule:: AI_Rule NX
  # 2.
  # score:: XRAZo郁\bh̃V{
  # execute:: ANVs郁\bh̃V{
  def add_rule(*args)
    if @rule_list.nil?
      @rule_list = []
    end
    case args.size
    when 1
      rule = args[0]
    when 2
     (score, execute) = args
      rule = AI_Rule_Symbol_Method.new
      rule.score_symbol = score
      rule.execute_symbol = execute
    end
    rule.ai = self
    @rule_list.push rule
  end
  
  # [폜
  def clear_rule
    @rule_list = []
  end
  
end
