# Cj[
# Authors:: fukuyama
# Date:: 2011/12/19
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module DQ
  # Cj[
  class Window_Main_Menu < ::DQ::Window_Command_Base
    include Window_Tree_Module
    # 
    def initialize
      super(nil,16,16)
      @window_gold = Window_Gold.new
      @window_gold.right = Graphics.width - 16
      @window_gold.top = 16
      add_child(@window_gold)
      
      if $game_party.exists
        # o[Ƃ\
        @window_status = Window_Main_Menu_Status.new
        add_child(@window_status)
      end
    end

    # R}hXg̍쐬
    def make_command_list
      # XXX: refresh ɑΉāAj[ON/OFFH
      add_command(Vocab::MenuTalk, :menu_talk, $game_party.exists)
      add_command(Vocab::MenuSkill, :menu_skill, $game_party.exists)
      add_command(Vocab::MenuItem, :menu_item, $game_party.exists)
      add_command(Vocab::MenuCheck, :menu_check, $game_party.exists)
      add_command(Vocab::MenuStatus, :menu_status, $game_party.exists)
      add_command(Vocab::MenuOperation, :menu_operation)
    end

    # j[J
    def col_max
      return 2
    end

    # ͂Ȃ
    def menu_talk
      # o[Ȍꍇ́A\Ȃ
      return if not $game_party.exists
      # ʃCxǧgK[Cxg`FbN
      $game_player.check_event_trigger_there([0,1,2])
      if not $game_map.any_event_starting?
        # Cxgꍇ͒ԂƘb
#        $game_player.check_event_trigger_talk()
        p '' if $TEST
      end
      close
    end

    # 
    def menu_skill
      # o[Ȍꍇ́A\Ȃ
      return if not $game_party.exists
      window = Window_Actor_Menu_Skill.new(self)
      self.active_window = window.class
    end

    # ǂ
    def menu_item
      # o[Ȍꍇ́A\Ȃ
      return if not $game_party.exists
      window = Window_Actor_Menu_Item.new(self)
      self.active_window = window.class
    end

    # ׂ
    def menu_check
      # o[Ȍꍇ́A\Ȃ
      return if not $game_party.exists
      # gK[Cxg`FbN
      if not $game_player.check_action_event
        e = Script_Event.new
        e.message(Vocab::MenuCheckLog)
        e.blank
        SceneManager.scene.interpreter.setup(e.event_commands)
      end
      close
    end

    # 悳
    def menu_status
      # o[Ȍꍇ́A\Ȃ
      return if not $game_party.exists
      window = Window_Actor_Menu_Status.new(self)
      self.active_window = window.class
    end

    # 
    def menu_operation
      window = Window_Operation_Menu.new(self)
      self.active_window = window.class
    end
  end
end
