# AN^[̉
# Authors:: fukuyama
# Date:: 2012/04/18
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

class Game_Actor
  # ol̕ύX
  # show:: xAbv\tO
  def change_exp(exp, show)
    @exp[@class_id] = [exp, 0].max
    last_level = @level
    last_skills = skills
    level_up while !max_level? && self.exp >= next_level_exp
    level_down while self.exp < current_level_exp
    display_level_up(@level - last_level,skills - last_skills) if show && @level > last_level
    refresh
  end

  # xAbvbZ[W̕\
  # new_skills:: VKXL̔z
  def display_level_up(up_level,new_skills)
    $game_message.new_page
    $game_message.add(sprintf(Vocab::LevelUp, @name, Vocab::level, @level))
    8.times do |param_id|
      name = Vocab::param(param_id)
      @level -= up_level
      last_param = param(param_id)
      @level += up_level
      param = param(param_id) - last_param
      if param > 0
        $game_message.add(sprintf(Vocab::Battle::ParamUp, name, param))
      elsif param < 0
        $game_message.add(sprintf(Vocab::Battle::ParamDown, name, param.abs))
      end
    end
    new_skills.each do |skill|
      $game_message.add(sprintf(Vocab::ObtainSkill, skill.name))
    end
  end

end
