# sW[
# Authors:: fukuyama
# Date:: 2011/12/29
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module Process_Auto_New_Line_Module
  METHOD_PREFIX = '_Process_Auto_New_Line_Module_' if not defined? METHOD_PREFIX
  def process_auto_new_line(c, text, pos)
    unless c == "\n" or c == "\f" or c == "\e"
      text_width = text_size(c).width
      if contents.width < (pos[:x] + text_width) 
        process_new_line(text, pos)
      end
    end
  end
  
  # \bhĒ`
  def self.included(klass)
    klass.module_eval <<-EVAL
    alias :#{METHOD_PREFIX}process_character :process_character
    def process_character(c, text, pos)
      process_auto_new_line(c, text, pos)
      #{METHOD_PREFIX}process_character(c, text, pos)
    end
    EVAL
  end
end

class Window_Base
  include Process_Auto_New_Line_Module
end
