# AN^[R}hEBhE
# Authors:: fukuyama
# Date:: 2012/03/04
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  module Battle
    class Window_Actor_Command < ::DQ::Battle::Window_Battle_Command
      include Window_Tree_Module
      include Window_Command_Title_Module
      include Window_Target_Module

      # 
      def initialize()
        self.title = "test"
        super(nil,0, 0)
        self.openness = 0
        self.unselect
        self.deactivate
        @actor = nil
      end

      # R}hXg̍쐬
      def make_command_list
        add_command(Vocab::attack, :command_attack, @actor ? @actor.attack_usable? : false)
        add_command(Vocab::skill, :command_skill, true)
        add_command(Vocab::item, :command_item)
        add_command(Vocab::guard, :command_guard, @actor ? @actor.guard_usable? : false)
      end

      # EBhE̎擾
      def window_width
        return 128
      end

      # ZbgAbv
      def setup(actor)
        @actor = actor
        self.title = @actor.name
        clear_command_list
        make_command_list
        refresh
        select(0)
        activate
        open
      end

      def command_attack
        @actor.input.set_attack
        window = Window_Battle_Enemy.new(self,@actor)
        self.active_window = window.class
      end

      def command_skill
        window = Window_Skill.new(self,@actor)
        self.active_window = window.class
      end

      def command_item
        window = Window_Item.new(self,@actor)
        self.active_window = window.class
      end

      def command_guard
        @actor.input.set_guard
        SceneManager.scene.next_command
      end

      # LZ
      def cancel
        SceneManager.scene.prior_command
      end
    end
  end
end
