# DQbZ[WEBhE
# Authors:: fukuyama
# Date:: 2011/12/14
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module DQ
  # EBhEXN[bZ[W(DQbZ[WEBhE)
  class Window_Scroll_Message < Window_Base
    # 
    def initialize(message_window)
      @message_window = message_window
      super(0, 0, @message_window.window_width, @message_window.window_height)
      self.z = message_window.z + 10
      self.opacity = 0
      self.arrows_visible = false
      clear_instance_variables
    end

    # EBhEe̍vZ
    def contents_height
      #@{EBhÊQ{ɂ
      super * 2
    end

    # CX^Xϐ̃NA
    def clear_instance_variables
      @pos = nil
      @text = ""
      @scroll_up = 0
      @scroll_speed = 2
    end

    # EBhEN[Y
    def close
      clear_instance_variables
      self.contents.clear()
      super
    end

    # EBhE̍XV
    def update
      super
    end

    # EBhËʒuXV
    def update_placement
      self.y = @message_window.y
    end

    # XN[̍XV
    def update_scroll
      # XN[
      if @scroll_up > 0 and (@pos[:ay] != self.oy)
        n = 0
        if @scroll_speed != 0
          n = @scroll_speed
          n = @scroll_up if @scroll_up < n
        else
          n = @pos[:height]
        end
        n = 1 if n <= 0
        @scroll_up -= n
        self.oy += n
        return true
      end
      if @pos[:ay] != self.oy
        # \͈͂𒴂ĂꍇA܂ŃXN[
        if (self.oy + @message_window.contents_height()) <= @pos[:y]
          @scroll_up = @pos[:height]
          return true
        end
      end
      if @pos[:y] != @pos[:py]
        @scroll_up = @pos[:height]
        @pos[:py] = @pos[:y]
        return true
      end
      return false
    end

    # y[W
    def new_page(text, pos)
      # ʒuۑ
      if @pos.nil?
        @pos = pos
      end
      @text = text
      # \ʒu𒲐
      pos[:y] = @pos[:y] # Ŷݕۑ ݂̕\ʒu
      @pos = pos
      @pos[:ay] = @pos[:y]
      @pos[:py] = @pos[:y]
    end

    # Rec̏
    # XN[Ƃ܂ɁAXN[Ăꂽ\ʒu
    def contents_initialize
      # XN[IbZ[WSĕ\Ăꍇ
      if @scroll_up <= 0 and @text.empty?
        # XN[rbg}bv̈ԏɂăXN[ʒu
        @scroll_up = 0
        r = self.contents.rect
        r.y = @pos[:ay]
        bmp = self.contents.dup
        self.contents.clear
        self.contents.blt(0, 0, bmp, r)
        self.oy = 0
        bmp.dispose
        @pos[:y] = @pos[:y] - @pos[:ay]
        @pos[:ay] = 0
      end
    end

    #@ׂẴeLXgIƂ̏
    def process_all_text_end
      # \bZ[Wԏɗ悤ɃXN[
      @scroll_up = @pos[:ay] - self.oy
      while update_scroll
        Fiber.yield
      end
      contents_initialize()
    end

    # ʏ핶̏
    def process_normal_character(c, pos)
      # ɏĂ炤
      super
    end

    # 䕶̏
    def process_escape_character(code, text, pos)
      # EBhEŗL̐䕶ȊOicontentsɉê镨j͂łĂ炤
      super
    end

  end

  #@Window_MessagepW[
  module Window_Message_Module
    # ̏
    def process_character(c, text, pos)
      super
      while @window_scroll_message.update_scroll
        Fiber.yield
      end
    end

    # ʏ핶̏
    def process_normal_character(c, pos)
      @window_scroll_message.process_normal_character(c, pos)
    end

    # 䕶̏
    def process_escape_character(code, text, pos)
      @window_scroll_message.process_escape_character(code, text, pos)
    end

    # EBhEI[v
    def open
      # A
      @window_scroll_message.open
      super
    end

    # EBhEN[Y
    def close
      # A
      @window_scroll_message.close
      super
    end

    def z=(n)
      if not @window_scroll_message.nil?
        @window_scroll_message.z = @window_scroll_message.z - self.z + n
        @choice_window.z = n
        @number_window.z = n
        @item_window.z = n
      end
      super(n)
    end

    # \bhĒ`
    def self.included(klass)
      # XXX: process_new_line ͖̂肠肻c
      klass.module_eval <<-EVAL
      def process_new_line(text, pos)
        @line_show_fast = false
        super
      end
      alias :#{METHOD_PREFIX}process_all_text :process_all_text
      def process_all_text
        #{METHOD_PREFIX}process_all_text
        @window_scroll_message.process_all_text_end
      end
      alias :#{METHOD_PREFIX}new_page :new_page
      def new_page(text, pos)
        #{METHOD_PREFIX}new_page(text, pos)
        @window_scroll_message.new_page(text, pos)
      end
      alias :#{METHOD_PREFIX}update_placement :update_placement
      def update_placement
        #{METHOD_PREFIX}update_placement()
        @window_scroll_message.update_placement
      end

      alias :#{METHOD_PREFIX}create_all_windows :create_all_windows
      def create_all_windows
        @window_scroll_message = Window_Scroll_Message.new(self)
        #{METHOD_PREFIX}create_all_windows()
      end
      alias :#{METHOD_PREFIX}dispose_all_windows :dispose_all_windows
      def dispose_all_windows
        @window_scroll_message.dispose
        #{METHOD_PREFIX}dispose_all_windows()
      end
      alias :#{METHOD_PREFIX}update_all_windows :update_all_windows
      def update_all_windows
        @window_scroll_message.update
        #{METHOD_PREFIX}update_all_windows()
      end
      EVAL
    end
  end
end

class Window_Message
  include DQ::Window_Message_Module
end
