# ^[QbgXe[^XEBhE\郂W[
# Authors:: fukuyama
# Date:: 2012/01/22
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  class Window_Target_Status < ::Window_Help
  end

  module Window_Target_Status_Module
    # 
    def initialize_target_status(x,y,w)
      help_window = Window_Target_Status.new(2)
      help_window.width = w
      help_window.create_contents
      help_window.top = y
      help_window.left = x
      self.help_window = help_window

      # qEBhEɒǉ
      add_child(help_window)

      @prev_target_index = -1

      if refresh_hp?
        @target_status_mode = :hp
      elsif refresh_mp?
        @target_status_mode = :mp
      elsif refresh_condition?
        @target_status_mode = :condition
      else
        @target_status_mode = :hp
      end
    end

    # ACeEBhET
    def find_window_item
      window = find_window(::DQ::Window_Item)
      #      window = find_window(::DQ::Battle::Window_Item) if window.nil?
      return window
    end

    # XLEBhET
    def find_window_skill
      window = find_window(::DQ::Window_Skill)
      #      window = find_window(::DQ::Battle::Window_Skill) if window.nil?
      return window
    end

    # ΏۃXe[^X̍XVil\́j
    def refresh_target_value(n,m,word)
      color = '\C[0]'
      if n == 0
        color = '\C[1]'
      elsif n < m / 4
        color = '\C[2]'
      end
      n = "%4d" % n
      m = "%4d" % m
      text = ''
      text << "\\C[0]\\left[#{word}]\n"
      text << "#{color}\\center_left[#{n} ]"
      text << "\\C[0]\\center_right[/ #{m}]"
      self.help_window.set_text(text)
    end

    # ΏۃXe[^X̍XViXe[gj
    def refresh_target_condition()
      self.help_window.clear
      text = "\\C[0]\\left[]"
      self.help_window.set_text(text)
      x = 0
      y = line_height
      self.help_window.draw_actor_icons(actor,x,y,self.help_window.contents.width)
    end

    # HPΏۂɂXVH
    def refresh_hp?
      window = find_window_item
      unless window.nil?
        item = Item_Facade.get_use_item(window.item)
        return false if item.nil?
        return item.recover_hp_item?
      end
      window = find_window_skill
      unless window.nil?
        skill = window.skill
        return skill.damage.to_hp?
      end
      return false
    end

    # MPΏۂɂXVH
    def refresh_mp?
      window = find_window_item
      unless window.nil?
        item = Item_Facade.get_use_item(window.item)
        return false if item.nil?
        return item.recover_mp_item?
      end
      window = find_window_skill
      unless window.nil?
        skill = window.skill
        return skill.damage.to_mp?
      end
      return false
    end

    # ԕωΏۂɂXVH
    def refresh_condition?
      window = find_window_item
      unless window.nil?
        item = Item_Facade.get_use_item(window.item)
        return false if item.nil?
        return item.state_change_item?
      end
      window = find_window_skill
      unless window.nil?
        skill = window.skill
        return (not skill.effects.empty?)
      end
      return false
    end

    # ^[QbgXe[^XXV
    def refresh_target_status()
      case @target_status_mode
      when :hp
        refresh_target_value(actor.hp,actor.mhp,Vocab::hp_a())
      when :sp
        refresh_target_value(actor.mp,actor.mmp,Vocab::mp_a())
      when :condition
        refresh_target_condition()
      end
    end

    # wvXV
    def update_help()
      if not self.help_window.disposed?
        refresh_target_status()
      end
    end
  end
end
