# AN^[ACe
# Authors:: fukuyama
# Date:: 2012/01/29
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  # ACeEBhE 'Actor_Equip_Item'
  class Window_Status_Equip < ::Window_Base
    include Window_Tree_Module
    # IuWFNg
    def initialize(parent)
      window_actor_summary = parent.find_window(Window_Status_Summary)
      x = window_actor_summary.left
      y = window_actor_summary.bottom
      w = CHARA_WIDTH * 8 + standard_padding * 2 + 8
      h = fitting_height(5)
      super(parent,x,y,w,h)
    end

    # AN^[̐ݒ
    def actor=(actor)
      if @actor != actor
        @actor = actor
        refresh
      end
    end

    # tbV
    def refresh
      self.contents.clear
      return if @actor.nil?

      index = 0
      rect = Rect.new(0,0,self.contents.width,line_height)
      @actor.equips.each do |item|
        rect.y = index * line_height
        change_color(normal_color)
        draw_menu_item(index,rect,item)
        index += 1
      end
    end

    # ڂ̕`
    def draw_menu_item(index,rect,item)
      name = ''
      name = 'E ' + item.name if not item.nil?
      self.contents.fill_rect(rect, Color.new(0, 0, 0, 0))
      self.contents.draw_text(rect, name)
    end
  end

end
