# Cj[Xe[^X
# Authors:: fukuyama
# Date:: 2011/12/19
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module DQ
  # Cj[Xe[^X
  class Window_Main_Menu_Status < Window_Base

    ACTOR_WIDTH = 80
    ACTOR_SPACING = 14
    # IuWFNg
    def initialize
      @state = true
      width = window_width
      height = window_height
      x = Graphics.width - width - 16
      y = Graphics.height - height - 16
      super(x, y, width, height)
    end

    # o[Xg
    def members
      $game_party.members
    end

    # EBhEe̕vZ
    def contents_width
      (ACTOR_WIDTH + ACTOR_SPACING) * self.members.size - ACTOR_SPACING
    end

    # EBhEe̍vZ
    def contents_height
      line_height * 4
    end

    # EBhEvZ
    def window_width
      contents_width + standard_padding * 2
    end

    # EBhEvZ
    def window_height
      contents_height + standard_padding * 2
    end

    # XV
    def update
      super
      refresh
    end

    # tbVKv邩ǂf邽߂̃nbVl
    def refresh_code
      return self.members.collect(){|a|[a.hp,a.mp,a.level,a.states.size]}.hash
    end

    # tbVKvǂH
    def need_refresh?
      update_status = refresh_code
      if @refresh_status == update_status
        return false
      end
      @refresh_status = update_status
      return true
    end

    # tbV
    def refresh(force=false)
      if force or need_refresh?
        h = window_height
        w = window_width
        if self.width != w or self.height != h
          self.width = w
          self.height = h
          create_contents
        end
        self.members.each(){|actor|refresh_actor(actor)}
      end
    end

    # AN^[̍XV
    def refresh_actor(actor)
      unless actor.is_a? Game_Actor
        return
      end
      # O
      refresh_actor_name(actor)
      # HP
      refresh_actor_hp(actor)
      # MP
      refresh_actor_mp(actor)
      # Xe[g
      refresh_actor_state(actor)
    end

    # AN^[̍XV
    def refresh_actor_name(actor)
      i = self.members.index(actor)
      x = (ACTOR_WIDTH + ACTOR_SPACING) * i
      y = 0
      change_color(normal_color)
      self.contents.font.size -= 2
      self.contents.fill_rect(x, y, ACTOR_WIDTH, line_height, Color.new(0,0,0,0))
      self.contents.draw_text(x, y, ACTOR_WIDTH, line_height, actor.name, 0)
      self.contents.font.size += 2
    end

    # AN^[HPXV
    def refresh_actor_hp(actor)
      i = self.members.index(actor)
      x = (ACTOR_WIDTH + ACTOR_SPACING) * i
      y = line_height
      change_color(system_color)
      self.contents.fill_rect(x, y, ACTOR_WIDTH, line_height, Color.new(0,0,0,0))
      self.contents.draw_text(x, y, ACTOR_WIDTH, line_height, Vocab.hp_a, 0)
      change_color(normal_color)
      self.contents.font.color = crisis_color   if actor.hp <= actor.mhp / 4
      self.contents.font.color = knockout_color if actor.hp == 0
      self.contents.draw_text(x, y, ACTOR_WIDTH, line_height, actor.hp.to_s, 2)
    end

    # AN^[MPXV
    def refresh_actor_mp(actor)
      i = self.members.index(actor)
      x = (ACTOR_WIDTH + ACTOR_SPACING) * i
      y = line_height * 2
      change_color(system_color)
      self.contents.fill_rect(x, y, ACTOR_WIDTH, line_height, Color.new(0,0,0,0))
      self.contents.draw_text(x, y, ACTOR_WIDTH, line_height, Vocab.mp_a, 0)
      change_color(normal_color)
      self.contents.font.color = crisis_color   if actor.mp != actor.mmp and actor.mp <= actor.mmp / 4
      self.contents.draw_text(x, y, ACTOR_WIDTH, line_height, actor.mp.to_s, 2)
    end

    # AN^[̃Xe[gXV
    def refresh_actor_state(actor)
      return unless @state
      i = self.members.index(actor)
      x = (ACTOR_WIDTH + ACTOR_SPACING) * i
      y = line_height * 3
      self.contents.fill_rect(x, y, ACTOR_WIDTH, line_height, Color.new(0,0,0,0))
      draw_state_line(x,y,ACTOR_WIDTH,line_height,actor)
    end

    def draw_state_line(x,y,width,height,actor)
      if actor.normal?
        change_color(system_color)
        self.contents.draw_text(x, y, width, height, Vocab.level_a, 0)
        change_color(normal_color)
        self.contents.draw_text(x, y, width, height, actor.level.to_s, 2)
      else
        draw_actor_icons(actor, x, y, width)
      end
    end

    def state_off
      return unless @state
      @state = false
      refresh(true)
    end

    def state_on
      return if @state
      @state = true
      refresh(true)
    end
  end

end
