# ĂEBhE
# Authors:: fukuyama
# Date:: 2012/02/27
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  class Window_Config_Item < ::DQ::Window_Command_Base
    include Window_Tree_Module
    include Window_Command_Title_Module
    # IuWFNg
    def initialize(parent,config)
      @config = config
      @index = @config.values.index(@config.get.call())
      @config.texts.each do |text|
        add_menu(text.to_s, :select_config)
      end
      @left_label_width = 0
      @right_label_width = 0

      case @config.texts[0]
      when Integer
        label_test = Bitmap.new(640,32)
        @cellspacing = Rect.new(4,0,4,0) if @cellspacing.nil?
        @left_label_width = label_test.text_size(@config.min_label).width + @cellspacing.x + @cellspacing.width
        @right_label_width = label_test.text_size(@config.max_label).width
        label_test.dispose
        @column_max = @config.texts.size
      when String
        @column_max = 1
      end

      self.title = @config.name
      super(parent,parent.top + 32,parent.left + 32)
    end

    def select_config
      @config.set.call(@config.values[@index])
      self.parent.refresh
      dispose
    end

    # tbV
    def refresh
      super
      case @config.texts[0]
      when Integer
        self.contents.font.size -= 2
        w = self.contents.width
        h = _menu_height
        x = 0
        y = _title_height
        self.contents.draw_text(x,y,w,h,@config.min_label,0)
        self.contents.draw_text(x,y,w,h,@config.max_label,2)
        self.contents.font.size += 2
      when String
        # XXX: ȂɂȂH
      end
    end
  end

  class Window_Config < ::DQ::Window_Command_Base
    include Window_Tree_Module
    include Window_Command_Title_Module

    @@configs = []
    class Config
      attr_accessor :name
      attr_accessor :values
      attr_accessor :texts
      attr_accessor :get
      attr_accessor :set
      attr_accessor :min_label
      attr_accessor :max_label
    end

    def self.create(name,values,texts)
      cf = Config.new
      cf.name = name
      cf.values = values
      cf.texts  = texts
      @@configs.push cf
      return cf
    end

    # IuWFNg
    def initialize(parent)
      self.title = Vocab::MenuGameConfigTitle
      # ݒl̃obNAbv
      @backup_config = []
      for cf in @@configs
        @backup_config.push cf.get.call
      end
      # EBhEʒu
      rect = parent.item_rect_for_text(parent.index)
      super(parent,parent.left + rect.x - 4,parent.top + rect.y)
    end

    # R}hXg̍쐬
    def make_command_list
      for cf in @@configs
        add_command(cf.name, :command_config)
      end
    end

    # ݒ荀ڑI
    def command_config
      window = Window_Config_Item.new(self,@@configs[self.index])
      self.active_window = window.class
    end

    # ڂ̕`
    def draw_menu_item(index,color,rect,name)
      super
      if @@configs.size <= index
        return
      end
      cf = @@configs[index]
      text = cf.texts[cf.values.index(cf.get.call)].to_s
      self.contents.font.size -= 2
      self.contents.draw_text(rect,text,2)
      self.contents.font.size += 2
    end

  end

end
