# AN^[j[XL
# Authors:: fukuyama
# Date:: 2012/01/13
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  # XLI[i[Xe[^X
  class Window_Skill_Owner_Status < ::Window_Help
    # XLI[i[Xe[^Xĕ`
    def set_actor(actor)
      n = actor.mp
      m = actor.mmp
      n = sprintf("%4d",n)
      m = sprintf("%4d",m)
      text = ''
      text << "\\left[#{Vocab::mp_a}]\n"
      text << "\\center_left[#{n} ]"
      text << "\\center_right[/ #{m}]"
      set_text(text)
    end
  end

  class Window_Actor_Menu_Skill < ::DQ::Window_Actor_Menu_Base
    include Window_Command_Title_Module
    # 
    def initialize(parent)
      self.title = Vocab::MenuActorSkillTitle
      # EBhEʒu
      rect = parent.item_rect_for_text(parent.index)
      super(parent,parent.left + rect.x - 4,parent.top + rect.y)

      # XLEBhE쐬
      @window_skill = Window_Skill.new(self)

      # XLI[i[Xe[^X
      gold_window = find_window(Window_Gold)
      help_window = Window_Skill_Owner_Status.new(2)
      help_window.top = @window_skill.top
      help_window.left = @window_skill.right
      help_window.width = gold_window.right - @window_skill.right
      help_window.create_contents()
      add_child(help_window)
      self.help_window = help_window
    end

    # wvXV
    def update_help
      if not self.help_window.disposed?
        self.help_window.set_actor(actor)
      end
    end

    # AN^[I
    def select_actor
      skills = self.actor.skills.select() {|s|s.menu_ok?}
      if skills.size != 0
        # XLEBhEANeBu
        self.active_window = @window_skill.class
        # J[\ʒuAŏɂB
        @window_skill.index = 0
      else
        # XLꍇ̓ANeBuɖ߂
        self.activate()
      end
    end

    # Iς̏
    def change_index
      @window_skill.refresh
    end

  end
end
