# AN^[j[ACe
# Authors:: fukuyama
# Date:: 2011/12/19
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module DQ
  class Window_Actor_Menu_Item < ::DQ::Window_Actor_Menu_Base
    include Window_Command_Title_Module
    # 
    def initialize(parent)
      self.title = Vocab::MenuActorItemTitle
      # EBhEʒu
      rect = parent.item_rect_for_text(parent.index)
      super(parent,parent.left + rect.x - 4,parent.top + rect.y)

      # ACeEBhE쐬
      @window_item = Window_Item.new(self)
    end

    # R}hXg̍쐬
    def make_command_list
      super
      add_command(Vocab::MenuBackpack, :select_party_backpack)
      add_command(Vocab::MenuArrangementItem, :arrangement_item)
      add_command(Vocab::MenuArrangementBackpack, :arrangement_backpack)
    end

    # Iς̏
    def change_index
      if current_symbol == :arrangement_item or current_symbol == :arrangement_backpack
        @window_item.hide
      else
        @window_item.refresh
        @window_item.show
      end
    end

    # ܂I
    def select_party_backpack
      if $game_party.backpack.item_count != 0
        # ACeEBhEANeBu
        self.active_window = @window_item.class
        # J[\ʒuAŏɂB
        @window_item.index = 0
      else
        # ACeꍇ̓ANeBuɖ߂
        self.activate()
      end
    end

    # AN^[I
    def select_actor
      if self.actor.backpack.item_count != 0
        # ACeEBhEANeBu
        self.active_window = @window_item.class
        # J[\ʒuAi̎ɂB
        @window_item.index = self.actor.equips.compact.size
        # iĂȂꍇ́Aԉɂ
        if self.actor.backpack.item_count <= @window_item.index
          @window_item.index = self.actor.backpack.item_count - 1
        end
      else
        # ACeꍇ̓ANeBuɖ߂
        self.activate()
      end
    end

    # ǂI
    def arrangement_item
      window = Window_Actor_Menu_Item_Arrange.new(self)
      self.active_window = window.class
    end

    # ӂ됮I
    def arrangement_backpack
      window = Window_Backpack_Arrange.new(self)
      self.active_window = window.class
    end
  end
end

