# ogʂ̏sNXłB
# Authors:: fukuyama
# Date:: 2012/03/03
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  module Battle
    class Scene_Battle < ::Scene_Battle
      # \r[|[g̍쐬
      def create_info_viewport
        @info_viewport = Viewport.new
        @info_viewport.z = 100
        @status_window.viewport = @info_viewport
      end

      # Xe[^XEBhE̍쐬
      def create_status_window
        @status_window = Window_BattleStatus.new
      end

      # p[eBR}hEBhE̍쐬
      def create_party_command_window
        @party_command_window = Window_Party_Command.new
        @party_command_window.y = Graphics.height - @party_command_window.height
        @party_command_window.viewport = @info_viewport
        @party_command_window.set_handler(:fight,  method(:command_fight))
        @party_command_window.set_handler(:escape, method(:command_escape))
        @party_command_window.set_handler(:config, method(:command_config))
        @party_command_window.unselect
      end

      # AN^[R}hEBhE̍쐬
      def create_actor_command_window
        @actor_command_window = Window_Actor_Command.new
        @actor_command_window.y = Graphics.height - @actor_command_window.height
        @actor_command_window.viewport = @info_viewport
        @actor_command_window.set_handler(:attack, method(:command_attack))
        @actor_command_window.set_handler(:skill,  method(:command_skill))
        @actor_command_window.set_handler(:guard,  method(:command_guard))
        @actor_command_window.set_handler(:item,   method(:command_item))
        @actor_command_window.set_handler(:cancel, method(:prior_command))
      end

      # \r[|[g̍XV
      def update_info_viewport
      end

      def command_config
      end
    end
  end # module Battle
end # DQ

class Scene_Map < Scene_Base
  # GJEg̍XV
  def update_encounter
    SceneManager.call(::DQ::Battle::Scene_Battle) if $game_player.encounter
  end
end

class Game_Interpreter
  # og̏
  def command_301
    return if $game_party.in_battle
    if @params[0] == 0                      # ڎw
      troop_id = @params[1]
    elsif @params[0] == 1                   # ϐŎw
      troop_id = $game_variables[@params[1]]
    else                                    # }bvw̓GO[v
      troop_id = $game_player.make_encounter_troop_id
    end
    if $data_troops[troop_id]
      BattleManager.setup(troop_id, @params[2], @params[3])
      BattleManager.event_proc = Proc.new {|n| @branch[@indent] = n }
      $game_player.make_encounter_count
      SceneManager.call(::DQ::Battle::Scene_Battle)
    end
    Fiber.yield
  end
end
