# DQ ̃EBhER}hx[X
# Authors:: fukuyama
# Date:: 2011/12/15
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module DQ
  # DQ ̃EBhER}hx[X
  class Window_Command_Base < ::Window_Command
    # 
    def initialize(x, y)
      super(x, y)
      set_handlers()
    end

    # J[\ʒu̐ݒ
    def index=(index)
      super
      call_change_index_handler
    end

    # J[\ʒuύXꂽ̃nh
    def call_change_index_handler
      call_handler(:change_index)
    end

    # nh[ݒ
    def set_handlers()
      # ǉĂR}hɃnhݒ肷
      @list.each() do |command|
        symbol = command[:symbol]
        if respond_to?(symbol) and not handle?(symbol)
          set_handler(symbol, method(symbol))
        end
      end
      if not handle?(:cancel)
        if respond_to?(:cancel)
          set_handler(:cancel, method(:cancel))
        else
          set_handler(:cancel, method(:close))
        end
      end
      # nh
      if respond_to?(:change_index) and not handle?(:change_index)
        set_handler(:change_index, method(:change_index))
      end
    end

    # ɍڂԂƂ̋󔒂̕擾
    def spacing
      return 2
    end

    # EBhE̕
    def window_width
      # 12 ̓eLXgj[pXy[X
      return (menu_width + spacing + 12) * col_max - spacing + standard_padding * 2
    end

    # j[̕\s
    def visible_line_number
      n = super
      c = col_max()
      (n + n % c) / c
    end

    # j[̌̕vZ
    def menu_width
      bmp = Bitmap.new(Graphics.width,line_height())
      max_width = 0
      @list.each() do |command|
        max_width = [max_width,bmp.text_size(command[:name]).width].max
      end
      bmp.dispose
      return max_width
    end

    # XV
    def update
      if SceneManager.scene_is?(Scene_Menu) and SceneManager.scene.interpreter.running?
        return
      end
      super
    end

    # eXgp
    def unsupport
      msg  = "܂Ă܂B"
      e = Script_Event.new
      e.message(msg)
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

  end
end