# Window_Tree_Module
# KwIȃEBhEǗ
# Authors:: fukuyama
# Date:: 2011/12/19
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

# c[EBhEW[
module Window_Tree_Module
  attr_reader :parent
  # 
  def initialize(parent=nil, *args)
    @parent = parent if @parent.nil?
    @child_windows = []
    super(*args)
    @parent.add_child(self) if not @parent.nil?
  end

  # gbvEBhE̎擾
  def top_window
    if top_window?
      return self
    end
    return self.parent.top_window
  end

  def top_window?
    return self.parent.nil?
  end

  # c[ɂw肳ꂽEBhÊ݂ANeBuɂ
  def active_window=(klass)
    top_window._set_active_window_internal(klass)
  end

  def _set_active_window_internal(klass)
    self.active = self.is_a?(klass)
    @child_windows.each do |window|
      if not window.close?
        if window.is_a? Window_Tree_Module
          window._set_active_window_internal(klass)
        else
          window.active = window.is_a?(klass)
        end
      end
    end
  end

  # c[ɂw肳ꂽEBhE擾
  def find_window(klass)
    return top_window._find_window_internal(klass)
  end

  def _find_window_internal(klass)
    return self if self.is_a?(klass)
    result = nil
    @child_windows.each do |window|
      if not window.close?
        if window.is_a? Window_Tree_Module
          result = window._find_window_internal(klass)
          if not result.nil?
            break
          end
        else
          if window.is_a?(klass)
            result = window
            break
          end
        end
      end
    end
    return result
  end

  # ANeBuEBhE̎擾
  def active_window
    return top_window._find_active_window_internal
  end

  def _find_active_window_internal
    return self if self.active
    result = nil
    @child_windows.each do |window|
      if not window.close?
        if window.is_a? Window_Tree_Module
          result = window._find_active_window_internal
          if not result.nil?
            break
          end
        else
          if window.active
            result = window
            break
          end
        end
      end
    end
    return result
  end

  # SĂ̂yCfbNXXV
  def refresh_z_index
    if (not parent.nil?) and self.z <= parent.z
      self.z = parent.z + 20
    end
    @child_windows.each do |window|
      if not window.close?
        if window.is_a? Window_Tree_Module
          window.refresh_z_index
        else
          window.z = self.z + 20
        end
      end
    end
  end

  # qEBhE̒ǉ
  def add_child(window)
    return window if @child_windows.include?(window)
    @child_windows.push(window)
    top_window.refresh_z_index
    return window
  end

  # qEBhȄ
  def delete_child(window)
    return nil unless @child_windows.include?(window)
    @child_windows.delete(window)
    if not window.disposed?
      window.dispose
    end
    top_window.refresh_z_index
    return window
  end

  # XV
  def update
    update_child_windows
    return if close?
    super
  end

  # 
  def close
    @child_windows.each do |window|
      if not window.close?
        window.close
      end
    end
    super
  end

  # j
  def dispose
    @child_windows.each do |window|
      if not window.disposed?
        window.dispose
      end
    end
    @child_windows.clear
    super
  end

  # qEBhESăN[YĂ邩H
  def child_window_close?
    return @child_windows.all? do |window|
      if window.is_a? Window_Tree_Module
        window.child_window_close?
      else
        window.close?
      end
    end
  end

  # qEBhEɃANeBuȕ邩H
  def child_window_active?
    result = false
    @child_windows.each do |window|
      if not window.close?
        if window.is_a? Window_Tree_Module
          result = (window.active or window.child_window_active?)
        else
          result = window.active
        end
        if result
          break
        end
      end
    end
    return result
  end

  # qEBhE̍XV
  def update_child_windows
    @child_windows.dup.each do |window|
      if (not window.close?) or (not window.disposed?)
        window.update
      end
      # update  close Ăꍇ
      if window.close?
        delete_child(window)
        if (not close?) and active_window.nil?
          self.active = (not child_window_active?)
        end
      end
    end
  end
end
