# EBhEJ[\̃XvCg
# Authors:: fukuyama
# Date:: 2011/12/31
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module Window_Cursor_Module
  # J[\XvCg̎擾
  def sprite_cursor
    if @sprite_cursor.nil?
      @sprite_cursor = Sprite_Cursor.new(self.viewport)
      @sprite_cursor.visible = false
      @sprite_cursor.z = self.z + 2
      @sprite_cursor.bitmap = Cache.script_bitmap('cursor')
      #      @_sprite_cursor_prev_index = -1
    end
    return @sprite_cursor
  end

  #  def activate
  #    super
  #    update_cursor
  #  end
  #
  #  def deactivate
  #    super
  #    update_cursor
  #  end

  def update_open
    super
    self.sprite_cursor.visible = true if open?
  end

  def open
    super
    update_cursor
  end

  def close
    self.sprite_cursor.visible = false
    super
  end

  def dispose
    self.sprite_cursor.visible = false
    self.sprite_cursor.dispose unless self.sprite_cursor.disposed?
    @sprite_cursor = nil
    super
  end
  
  def viewport=(v)
    super(v)
    self.sprite_cursor.viewport = v
  end

  def x=(x)
    super(x)
    update_cursor
  end

  def y=(y)
    super(y)
    update_cursor
  end

  # J[\̍XV
  def update_cursor
    if @cursor_all
      cursor_rect.set(0, 0, contents.width, row_max * item_height)
      self.top_row = 0
    elsif @index < 0
      cursor_rect.empty
      self.sprite_cursor.visible = false
    else
      ensure_cursor_visible
      rect = item_rect(@index)
      tx = 4 + 16 / 2 - self.sprite_cursor.src_rect.width / 2
      ty = 2 + self.sprite_cursor.src_rect.height / 2
      self.sprite_cursor.x = self.x + rect.x + tx
      self.sprite_cursor.y = self.y + rect.y + ty
      self.sprite_cursor.z = self.z + 2
      self.sprite_cursor.visible = (self.visible and open?)
      #      cursor_rect.set(rect)
    end
  end
end

class Window_Command
  include Window_Cursor_Module
end
