# J[\XvCg
# Authors:: fukuyama
# Date:: 2011/12/31
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

class Sprite_Cursor < ::Sprite
  # 
  def initialize(viewport)
    super(viewport)
    @_blink_count = 0
    @_white_blink = false
  end

  def white_blink_on
    unless @_white_blink
      @_white_blink = true
      @_blink_count = 0
    end
  end

  def white_blink_off
    if @_white_blink
      @_white_blink = false
      self.color.set(0, 0, 0, 0)
    end
  end

  def update
    update_white_blink if @_white_blink
    super
  end

  def update_white_blink
    if @_white_blink
      @_blink_count = (@_blink_count + 1) % 32
      if @_blink_count < 16
        self.color.set(0, 0, 0, (16 - @_blink_count) * 6)
      else
        self.color.set(0, 0, 0, (@_blink_count - 16) * 6)
      end
    end
  end
end
