# ϊW[
# Authors:: fukuyama
# Date:: 2011/12/14
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module Convert_Characters_Module
  # ϊp^[̃Xg
  CONVERT_CHARACTERS = []
  # ϊp^[̊NX
  class ConvertBase
    # p^[
    attr_reader :pattern
    # IvV
    attr_reader :options
    # 
    # pattern:: p^[(K\IuWFNg)
    # options:: IvViHashj
    def initialize(pattern,options={})
      @pattern = pattern
      @options = options
    end

    # ϊ
    def convert(obj,match)
    end
  end

  # NX\bh
  # `ꂽ\bh include NX extend 邽߂̃W[
  module ClassMethods
    def add_convert_characters(pattern,op={},&block)
      CONVERT_CHARACTERS.push(Class.new(ConvertBase,&block).new(pattern,op))
    end
  end

  # W[ include ꂽ̏
  # NX\bh@extend 
  def self.included(klass)
    klass.extend(ClassMethods)
  end
end

# EBhEx[X
#
# ϊW[CN[hAϊB
# ftHg̕ϊ[
#
class Window_Base
  include Convert_Characters_Module
  # ϊ
  # text:: ϊ
  def convert_escape_characters(text)
    result = text.to_s.clone
    CONVERT_CHARACTERS.collect() do |o|
      result.gsub!(o.pattern) {o.convert(self,$~)}
    end
    result
  end

  add_convert_characters(/\\/) {def convert(w,match) "\e" end}
  add_convert_characters(/\e\e/) {def convert(w,match) "\\" end}
  add_convert_characters(/\eV\[(\d+)\]/i) {def convert(w,match) $game_variables[match[1].to_i] end}
  add_convert_characters(/\eV\[(\d+)\]/i) {def convert(w,match) $game_variables[match[1].to_i] end}
  add_convert_characters(/\eN\[(\d+)\]/i) {def convert(w,match) w.actor_name(match[1].to_i) end}
  add_convert_characters(/\eP\[(\d+)\]/i) {def convert(w,match) w.party_member_name(match[1].to_i) end}
  add_convert_characters(/\eG/i) {def convert(w,match) Vocab::currency_unit end}
end
