// MediaData.cpp: CMediaData NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MediaData.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

// stl::vector<BYTE>ŏȂ

#define	MINBUFSIZE	256UL		// ŏobt@TCY
#define MINADDSIZE	256UL		// ŏǉmۃTCY


CMediaData::CMediaData()
	: m_dwDataSize(0UL)
	, m_dwBuffSize(0UL)
	, m_pData(NULL)
{
	// ̃obt@𐶐

}

CMediaData::CMediaData(const CMediaData &Operand)
	: m_dwDataSize(0UL)
	, m_dwBuffSize(0UL)
	, m_pData(NULL)
{
	// Rs[RXgN^
	*this = Operand;
}

CMediaData::CMediaData(const DWORD dwBuffSize)
	: m_dwDataSize(0UL)
	, m_dwBuffSize(0UL)
	, m_pData(NULL)
{
	// obt@TCYw肵ăobt@𐶐
	GetBuffer(dwBuffSize);
}

CMediaData::CMediaData(const BYTE *pData, const DWORD dwDataSize)
	: m_dwDataSize(0UL)
	, m_dwBuffSize(0UL)
	, m_pData(NULL)
{
	// f[^lw肵ăobt@𐶐
	SetData(pData, dwDataSize);
}

CMediaData::CMediaData(const BYTE byFiller, const DWORD dwDataSize)
	: m_dwDataSize(0UL)
	, m_dwBuffSize(0UL)
	, m_pData(NULL)
{
	// tBf[^w肵ăobt@𐶐
	SetSize(dwDataSize, byFiller);
}

CMediaData::~CMediaData()
{
	if(m_pData)delete [] m_pData;		
}

CMediaData & CMediaData::operator = (const CMediaData &Operand)
{
	// obt@TCY̏܂ł̓Rs[Ȃ
	SetData(Operand.m_pData, Operand.m_dwDataSize);

	return *this;
}

BYTE * CMediaData::GetData() const
{
	// obt@|C^擾
	return (m_dwDataSize)? m_pData : NULL;
}

const DWORD CMediaData::GetSize() const
{
	// f[^TCY擾
	return m_dwDataSize;
}

void CMediaData::SetAt(const DWORD dwPos, const BYTE byData)
{
	// 1oCgZbg
	if(dwPos < m_dwDataSize)m_pData[dwPos] = byData;
}

const BYTE CMediaData::GetAt(const DWORD dwPos) const
{
	// 1oCg擾
	return (dwPos < m_dwDataSize)? m_pData[dwPos] : 0x00U;
}

const DWORD CMediaData::SetData(const BYTE *pData, const DWORD dwDataSize)
{
	if(dwDataSize){
		// obt@m
		GetBuffer(dwDataSize);

		// f[^Zbg
		::CopyMemory(m_pData, pData, dwDataSize);
		}

	// TCYZbg
	m_dwDataSize = dwDataSize;
	
	return m_dwDataSize;
}

const DWORD CMediaData::AddData(const BYTE *pData, const DWORD dwDataSize)
{
	if(!dwDataSize)return m_dwDataSize;

	// obt@m
	GetBuffer(m_dwDataSize + dwDataSize);
	
	// f[^ǉ
	::CopyMemory(&m_pData[m_dwDataSize], pData, dwDataSize);

	// TCYZbg
	m_dwDataSize += dwDataSize;
	
	return m_dwDataSize;
}

const DWORD CMediaData::AddData(const CMediaData *pData)
{
	return AddData(pData->m_pData, pData->m_dwDataSize);
}

const DWORD CMediaData::AddByte(const BYTE byData)
{
	// obt@m
	GetBuffer(m_dwDataSize + 1UL);
	
	// f[^ǉ
	m_pData[m_dwDataSize] = byData;

	// TCYXV
	m_dwDataSize++;

	return m_dwDataSize;
}

const DWORD CMediaData::TrimHead(const DWORD dwTrimSize)
{
	// f[^擪؂l߂
	if(!m_dwDataSize || !dwTrimSize){
		// Ȃ
		}
	else if(dwTrimSize >= m_dwDataSize){
		// Ŝ؂l߂
		m_dwDataSize = 0UL;		
		}
	else{
		// f[^ړ
		::MoveMemory(m_pData, m_pData + dwTrimSize, m_dwDataSize - dwTrimSize);
		m_dwDataSize -= dwTrimSize;
		}

	return m_dwDataSize;
}

const DWORD CMediaData::TrimTail(const DWORD dwTrimSize)
{
	// f[^؂l߂
	if(!m_dwDataSize || !dwTrimSize){
		// Ȃ
		}
	else if(dwTrimSize >= m_dwDataSize){
		// Ŝ؂l߂
		m_dwDataSize = 0UL;		
		}
	else{
		// f[^؂l߂
		m_dwDataSize -= dwTrimSize;
		}

	return m_dwDataSize;
}

const DWORD CMediaData::GetBuffer(const DWORD dwGetSize)
{
	if(dwGetSize <= m_dwBuffSize)return m_dwBuffSize;

	// ȂƂwTCYi[łobt@mۂ
	if(!m_pData){
		// obt@mۂ܂
		m_dwBuffSize = (dwGetSize > MINBUFSIZE)? dwGetSize : MINBUFSIZE;
		m_pData = new BYTE [m_dwBuffSize];
		}
	else if(dwGetSize > m_dwBuffSize){
		// vTCY̓obt@TCY𒴂
		m_dwBuffSize = (dwGetSize > MINBUFSIZE)? dwGetSize : MINBUFSIZE;
		if(m_dwBuffSize < (m_dwDataSize * 2UL))m_dwBuffSize = m_dwDataSize * 2UL;

		BYTE *pNewBuffer = new BYTE [m_dwBuffSize];

		// f[^Rs[
		if(m_dwDataSize){
			::CopyMemory(pNewBuffer, m_pData, m_dwDataSize);
			}
		
		// obt@J
		delete [] m_pData;

		// obt@ւ
		m_pData = pNewBuffer;
		}

	return m_dwBuffSize;
}

const DWORD CMediaData::SetSize(const DWORD dwSetSize)
{
	if(dwSetSize){
		// obt@m
		GetBuffer(dwSetSize);
		}

	// TCYZbg
	m_dwDataSize = dwSetSize;
	
	return m_dwDataSize;
}

const DWORD CMediaData::SetSize(const DWORD dwSetSize, const BYTE byFiller)
{
	// TCYZbg
	SetSize(dwSetSize);
	
	// f[^Zbg
	if(dwSetSize){
		::FillMemory(m_pData, dwSetSize, byFiller);
		}
		
	return m_dwDataSize;
}

void CMediaData::ClearSize(void)
{
	// f[^TCYNA
	m_dwDataSize = 0UL;
}

void CMediaData::Delete()
{
	// CX^X폜
	delete this;
}
