/*****************************************************************************
 *    Licensed to the Apache Software Foundation (ASF) under one
 *    or more contributor license agreements.  See the NOTICE file
 *    distributed with this work for additional information
 *    regarding copyright ownership.  The ASF licenses this file
 *    to you under the Apache License, Version 2.0 (the
 *    "License"); you may not use this file except in compliance
 *    with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing,
 *    software distributed under the License is distributed on an
 *    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *    KIND, either express or implied.  See the License for the
 *    specific language governing permissions and limitations
 *    under the License.
 *
 * AZup̃}N
 * $Id: rbtos_asm.inc 29 2012-11-17 18:28:25Z xeerda $
 *****************************************************************************/
#include <p32xxxx.h>
#include <sys/asm.h>

	.extern __iRBTOS_end_interrupt

.macro	RBTOS_PREV_INTERRUPT
	.set	noat
	mfc0	k0, _CP0_CAUSE
	mfc0	k1, _CP0_EPC
	srl	k0, k0, 0xa
	addiu	sp, sp, -128
	sw	k1, 40(sp)		// @(sp + 0) ... EPC
	mfc0	k1, _CP0_STATUS
	sw	k1, 44(sp)		// @(sp + 4) ... STATUS
	
	ins	k1, k0, 10, 6		// CP0_SETATUS  IPL<2:0> ɁCCP0_CAUSE  RIPL<2:0> Rs[
	ins	k1, zero, 1, 4		// UM, ERL, EXL  0
	mtc0	k1, _CP0_STATUS		// Ŋ֎~...
	
	sw	a0, 48(sp)
	sw	a1, 52(sp)
	sw	a2, 56(sp)
	sw	a3, 60(sp)
	sw	v0, 64(sp)
	sw	v1, 68(sp)
	sw	t0, 72(sp)
	sw	t1, 76(sp)
	sw	t2, 80(sp)
	sw	t3, 84(sp)
	sw	t4, 88(sp)
	sw	t5, 92(sp)
	sw	t6, 96(sp)
	sw	t7, 100(sp)
	sw	t8, 104(sp)
	sw	t9, 108(sp)
	sw	$ra, 112(sp)
	sw	$at, 116(sp)
	
	mfhi	a0
	mflo	a1
	sw	a0, 120(sp)
	sw	a1, 124(sp)
.endm

.macro	RBTOS_AFTER_INTERRUPT
	J		iRBTOS_end_interrupt
	nop
.endm
