/*****************************************************************************
 *    Licensed to the Apache Software Foundation (ASF) under one
 *    or more contributor license agreements.  See the NOTICE file
 *    distributed with this work for additional information
 *    regarding copyright ownership.  The ASF licenses this file
 *    to you under the Apache License, Version 2.0 (the
 *    "License"); you may not use this file except in compliance
 *    with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing,
 *    software distributed under the License is distributed on an
 *    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *    KIND, either express or implied.  See the License for the
 *    specific language governing permissions and limitations
 *    under the License.
 *
 * UART ̃AZuR[h
 * $Id: rbtUART_asm.S 10 2012-07-10 17:21:41Z xeerda $
 *****************************************************************************/
#include <p32xxxx.h>
#include <sys/asm.h>
#include "rbtos_asm.inc"

/*****************************************************************************
 * UART 2 
 *****************************************************************************/
	.set	nomips16
 	.set 	noreorder
	.extern IntUart2HandlerWrapper
	.extern	IntUart2Handler
	.ent	IntUart2HandlerWrapper
	
IntUart2HandlerWrapper:
	RBTOS_PREV_INTERRUPT
	
	addu	s8, sp, zero
	jal		IntUart2Handler
	nop
	addu	sp, s8, zero
	
	RBTOS_AFTER_INTERRUPT
	
	.end 	IntUart2HandlerWrapper
