/*****************************************************************************
 *    Licensed to the Apache Software Foundation (ASF) under one
 *    or more contributor license agreements.  See the NOTICE file
 *    distributed with this work for additional information
 *    regarding copyright ownership.  The ASF licenses this file
 *    to you under the Apache License, Version 2.0 (the
 *    "License"); you may not use this file except in compliance
 *    with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing,
 *    software distributed under the License is distributed on an
 *    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *    KIND, either express or implied.  See the License for the
 *    specific language governing permissions and limitations
 *    under the License.
 *
 * foCXւ̕o
 * $Id: rbtDevice.h 10 2012-07-10 17:21:41Z xeerda $
 *****************************************************************************/
#ifndef __RBT_DEVICE_H__
#define __RBT_DEVICE_H__
#include "rbtos.h"

#define ESC_COLOR_BLACK		"\033[30m"
#define ESC_COLOR_RED		"\033[31m"
#define ESC_COLOR_GREEN		"\033[32m"
#define ESC_COLOR_YELLOW	"\033[33m"
#define ESC_COLOR_BLUE		"\033[34m"
#define ESC_COLOR_PURPLE	"\033[35m"
#define ESC_COLOR_CYAN		"\033[36m"
#define ESC_COLOR_WHITE		"\033[37m"

/* OF邽߂̃}N`Q.
 * g. con_printf(ERROR_COLOR "Error!!\n" NORMAL_COLOR);
 */
#define ERROR_COLOR			ESC_COLOR_RED
#define INFO_COLOR			ESC_COLOR_GREEN
#define NORMAL_COLOR		ESC_COLOR_WHITE

/**
 * ֎~Ԃ con_printf()  uart_write() gp邽߂̃tOł.
 * CPU OȂǁCvIȏԂ烍Oo͂ƂɎgp܂.
 */
extern unsigned char fCritical;

extern RBTOS_LockT lockPrint;

/**
 * foCX\.
 */
typedef struct _RBTOS_DeviceT {
	/**
	 * foCXǂݏo.
	 * <p>
	 * length  1 ȏw肵ꍇCȂƂ 1 擾܂ŃubN܂.
	 * @param xbuff ǂݏoi[obt@.
	 * @param length ǂݏo.
	 * @return ۂɓǂݏo.
	 */
	int (*d_read)(char *xbuff, int length);
	
	/**
	 * foCXւ̏.
	 * <p>
	 * length ׂđMobt@ɏނ܂ŃubN܂.
	 * @param xbuff ޕw肵܂.
	 * @param length ޕw肵܂.
	 * @return ۂɏ񂾕 (= length)
	 */
 	int (*d_write)(const char *xbuff, int length);

	/**
	 * Mobt@̗Lf[^oCg̊mF.
	 * @return
	 *  Mobt@ɒ܂Ă镶ԋp܂.
	 */
 	int (*d_avail)(void);
 	
 	/**
 	 * foCX̏Ԏ擾.
 	 * @return
 	 *  foCXgp\̏ꍇC 0 ԋp܂.
 	 */
	int (*d_chkready)(void);
	
	/**
	 * foCX̏ԕω̃Cxg.
	 * <p>
	 * ȉ̏ꍇɃCxgʒm܂.
	 * - foCXgp\ɂȂƂ.
	 * - foCXgpsɂȂƂ.
	 * - foCX̎Mobt@Ƀf[^ǉꂽƂ.
	 * .
	 */
	RBTOS_EventT evtDevice; 
} RBTOS_DeviceT;


int dev_getchar(RBTOS_DeviceT *dd);
void dev_putchar(RBTOS_DeviceT *dd, char c);
void dev_putwchar(RBTOS_DeviceT *dd, RBTOS_WCHAR_T c);
int dev_putstring(RBTOS_DeviceT *dd, const char *msg);
void dev_printf(RBTOS_DeviceT *dd, const char *msg, ...);
void dev_vfprintf(RBTOS_DeviceT *dd, const char *msg, va_list ap);
void err_printf(const char *msg, ...);


extern RBTOS_DeviceT *devCon;


/**
 * Mobt@̗Lf[^oCg̊mF.
 * @return
 *  Mobt@ɒ܂Ă镶ԋp܂.
 */
int con_avail(void);

/**
 * 1 M.
 * <p>
 * 1 M܂ŃubN܂.
 * @return M.
 */
int con_getchar(void);

/**
 * 1 M.
 * <p>
 * Mobt@Ɋi[܂ŃubN܂.<br>
 * ̊֐ł LF  CR+LF ̕ϊ͍s܂.
 * @param c M镶.
 */
void con_putchar(char c);

/**
 * UCS  1 M.
 * <p>
 * Mobt@Ɋi[܂ŃubN܂.<br>
 * ̊֐ł LF  CR+LF ̕ϊ͍s܂.
 * @param c M镶.
 */
void con_putwchar(RBTOS_WCHAR_T c);

/**
 * ̑M.
 * <p>
 * k^[~l[g̕𑗐M܂.
 * ׂđMobt@Ɋi[܂ŃubN܂.<br>
 * ̊֐ł LF  CR+LF ̕ϊ͍s܂.
 * @param msg M镶w肵܂.
 * @return ۂɑMԋp܂.
 */
int con_putstring(const char *msg);

// Ȉ printf
void con_printf(const char *msg, ...);



int _con_assert(const char *s, const char *fname, const char *funcname, int line);

#define RBTOS_assert(x) (!!(x) || (_con_assert(#x, __FILE__, __FUNCTION__, __LINE__)))


#endif /* __RBT_DEVICE_H__ */
