/*****************************************************************************
 *    Licensed to the Apache Software Foundation (ASF) under one
 *    or more contributor license agreements.  See the NOTICE file
 *    distributed with this work for additional information
 *    regarding copyright ownership.  The ASF licenses this file
 *    to you under the Apache License, Version 2.0 (the
 *    "License"); you may not use this file except in compliance
 *    with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing,
 *    software distributed under the License is distributed on an
 *    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *    KIND, either express or implied.  See the License for the
 *    specific language governing permissions and limitations
 *    under the License.
 * 
 * TvvO main ֐
 * $Id: main.c 29 2012-11-17 18:28:25Z xeerda $
 *****************************************************************************/
#include <stdio.h>
#include <string.h>

#include "rbtos.h"
#include "rbtUART.h"

/** CONFIGURATION **************************************************/

#pragma config FVBUSONIO = OFF			// Controlled by Port Function
#pragma config FPLLMUL = MUL_20			// 20x Multiplier (4 x 20 = 80MHz)
#pragma config FPLLIDIV = DIV_2			// 2x Divider (4MHz)
#pragma config UPLLEN = OFF				// USB PLL: Disabled and Bypassed 
#pragma config FPLLODIV = DIV_2			// PLL Divide by 2 (40MHz)
#pragma config FNOSC = FRCPLL			// Fast RC (8MHz) Osc with PLL
#pragma config FSOSCEN = OFF			// Secondary Oscillator Disabled
#pragma config IESO     = OFF           // Internal/External Switch-over
#pragma config POSCMOD = OFF			// Primary osc disabled
#pragma config OSCIOFNC = OFF			// CLKO Output Signal disabled
#pragma config FPBDIV = DIV_1			// Pb_Clk is Sys_Clk/1 (40MHz)
#pragma config FCKSM = CSDCMD			// Clock Switch Disable, FSCM Disabled 
#pragma config FWDTEN = OFF				// WDT Disabled (SWDTEN Bit Controls)
#pragma config JTAGEN = OFF
#pragma config ICESEL   = ICS_PGx3      // ICE/ICD Comm Channel Select
#pragma config PWP      = OFF           // Program Flash Write Protect
#pragma config BWP      = OFF           // Boot Flash Write Protect
#pragma config CP       = OFF           // Code Protect
#ifdef __DEBUG
#pragma config DEBUG    = ON            // Background Debugger Enable
#else
#pragma config DEBUG    = OFF           // Background Debugger Disable
#endif
#pragma config UPLLIDIV = DIV_2         // USB PLL Input Divider


void ozCmdConsoleTask(void);

/*****************************************************************************
 * main
 *****************************************************************************/
int main(void)
{
	// 0b: PGED3 (input)
	// 1b: PGEC3 (input)
	ANSELA = 0;
	LATA = 0x3;
	TRISA = 0;
	ODCA = 0;
	CNPUA = 0;
	CNPDA = 0x3;
	
	// 0b: LED1 (output)
	// 1b: LED2 (output)
	// 8b: U2RX (input)
	// 9b: U2TX (output)
	ANSELB = 0;
	LATB = 0x200;
	TRISB = 0x0100;
	ODCB = 0;
	
	// CPU 
    SYSTEMConfig(40000000UL, SYS_CFG_WAIT_STATES | SYS_CFG_PCACHE);
	
	// OSCCON 5b: LOCK Zbg ܂ŃEFCg
	//   1: PLL module is lock or PLL module start-up timer is satisfied.
	while (OSCCONbits.SLOCK == 0) {
	}
	
	// Initialize LEDs
	mPORTBSetBits(BIT_0 | BIT_1);
	
	uart_init();
	devCon = devUART; // WR\[ UART ɐݒ.
	
	RBTOS_initialize();
	
	// L
	INTEnableSystemMultiVectoredInt();
	
	con_printf(INFO_COLOR "\n===============================================================================\n");
	con_printf(ESC_COLOR_CYAN " RBTOS Console Demo for PIC32MX220F032B\n");
	con_printf(ESC_COLOR_YELLOW " 2012 XEERDA\n");
	con_printf(INFO_COLOR "===============================================================================\n" NORMAL_COLOR);
	
	ozCmdConsoleTask();
	return 0;
}
