/*****************************************************************************
 *    Licensed to the Apache Software Foundation (ASF) under one
 *    or more contributor license agreements.  See the NOTICE file
 *    distributed with this work for additional information
 *    regarding copyright ownership.  The ASF licenses this file
 *    to you under the Apache License, Version 2.0 (the
 *    "License"); you may not use this file except in compliance
 *    with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing,
 *    software distributed under the License is distributed on an
 *    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *    KIND, either express or implied.  See the License for the
 *    specific language governing permissions and limitations
 *    under the License.
 * 
 * TvvO main ֐
 * $Id: main.c 28 2012-11-17 15:09:43Z xeerda $
 *****************************************************************************/
#include <stdio.h>
#include <string.h>

#include "rbtos.h"
#include "rbtUART.h"

/** CONFIGURATION **************************************************/

_FBS(		  BSS_OFF			// u[gZOgveNg
			& BWRP_OFF)			// u[gZOgCgveNg
_FGS(		  GWRP_OFF			// ʃZOgCgveNg
			& GSS0_OFF)			// ʃZOgR[hveNg
_FOSCSEL(	  IESO_OFF			// xX^[gAbvIESÕCl[urbg
			& LPRCSEL_HP		// LPRC Oscillator Power and Accuracy
			& SOSCSRC_ANA		// SOSC Source Type
//			& FNOSC_FRC)		// Fast RC Oscillator (FRC) (8MHz)
			& FNOSC_FRCPLL) 	// Fast RC Oscillator with Postscaler and PLL Module (FRCDIV+PLL)
_FOSC(		  FCKSM_CSDCMD		// FSCMƃNbNXCb`O̗fBZ[u
			& SOSCSEL_SOSCLP	// Secondary Oscillator configured for low-power operation
			& POSCFREQ_MS		// Primary oscillator/external clock input frequency between 100kHz and 8MHz
			& OSCIOFNC_OFF		// CLKO output disabled
			& POSCMOD_NONE)		// Primary oscillator disabled
_FWDT(		  WINDIS_OFF		// Windowed Watchdog Timer Disable bit:
			& FWDTEN_OFF		// WDTɃCl[uɂ邩ǂ̑I
			& FWPSA_PR128		// WDT prescaler ratio of 1:128
			& WDTPS_PS32768)	// Watchdog Timer Postscale Select bits:
_FPOR(		  MCLRE_ON			// MCLR Pin Enable bit:
			& BORV_V27			// Brown-out Reset set to lowest voltage (2.0V)
			& I2C1SEL_PRI		// Use Default SCL1/SDA1 Pins For I2C1
			& PWRTEN_ON			// Power-up Timer Enable bit:
			& LVRCFG_ON			// Low Voltage regulator is available and controlled by LVREN bit
			& BOREN_BOR3)		// Brown-out Reset enabled in hardware, SBOREN bit disabled
_FICD(		  ICS_PGx3)			// EMUC/EMUD share PGC2/PGD2
_FDS(		  DSWDTEN_OFF		// Deep Sleep Watchdog Timer Enable bit:
			& DSBOREN_OFF		// Deep Sleep Zero-Power BOR Enable bit:
			& DSWDTOSC_LPRC		// DSWDT uses Low Power RC Oscillator (LPRC)
			& DSWDTPS_DSWDTPSF)	// ep Sleep Watchdog Timer Postscale Select bits:


void ozCmdConsoleTask(void);

/*****************************************************************************
 * main
 *****************************************************************************/
int main(void)
{
	CLKDIVbits.RCDIV = 0;	// 1:1 = 8MHz
	while (OSCCONbits.LOCK == 0) {
	}
	
	ANSA = 0;
	ANSB = 0;
	
	TRISBbits.TRISB15 = 0; // RB15: LED

	uart_init();
	devCon = devUART; // WR\[ UART ɐݒ.
	
	// RBTOS  (ȌCRBTOS  API gp\)
	RBTOS_initialize();
	
	// 
	RBTOS_set_imask(0);
	
	con_printf(INFO_COLOR "\n===============================================================================\n");
	con_printf(ESC_COLOR_CYAN " RBTOS Console Demo for PIC24FV32KA301\n");
	con_printf(ESC_COLOR_YELLOW " 2012 XEERDA\n");
	con_printf(INFO_COLOR "===============================================================================\n" NORMAL_COLOR);
	
	ozCmdConsoleTask();
	return 0;
}
