/*!
  \file
  \brief ArchiveConfig のテスト

  \author Satofumi KAMIMURA

  $Id: TestArchiveConfig.cpp 261 2009-01-22 06:48:10Z satofumi $
*/

#include "TestArchiveConfig.h"
#include "ArchiveConfig.h"

using namespace std;


CPPUNIT_TEST_SUITE_REGISTRATION(TestArchiveConfig);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestArchiveConfig, "TestArchiveConfig");


void TestArchiveConfig::loadTest(void) {

  // 読み出し
  ArchiveConfig config("../theme/archive_list.txt");

  // 出力ファイル名のテスト
  string release_name = config.getReleaseName();
  CPPUNIT_ASSERT_EQUAL(string("../theme/lm_clocktheme_01.dat"),
                       release_name);

  // RRDA キーのテスト
  string rrda_key = config.getRrdaKey();
  CPPUNIT_ASSERT_EQUAL(string("LMTC"), rrda_key);

  // 通常データのテスト
  CPPUNIT_ASSERT_EQUAL(string("../theme/./lm_tc.xml"),
                       string(config.getNormalData("config")));
  CPPUNIT_ASSERT_EQUAL(string("../theme/./clock_base.png"),
                       string(config.getNormalData("base")));
  CPPUNIT_ASSERT_EQUAL(string("../theme/./segment.png"),
                       string(config.getNormalData("digital")));
  CPPUNIT_ASSERT_EQUAL(string("../theme/./hand_h.png"),
                       string(config.getNormalData("hari_h")));
  CPPUNIT_ASSERT_EQUAL(string("../theme/./hand_m.png"),
                       string(config.getNormalData("hari_m")));
  CPPUNIT_ASSERT_EQUAL(string("../theme/./hand_s.png"),
                       string(config.getNormalData("hari_s")));

  // 暗号化データのテスト
  CPPUNIT_ASSERT_EQUAL(string("../theme/./archive_list.txt"),
                       string(config.getRestrictData("dummy")));
}


void TestArchiveConfig::saveTest(void) {

  // デフォルト値で保存
  ArchiveConfig config("save_archive_sample.txt");
  config.save();

  // !!!

  // 出力できることを確認したので、よいことにする
  //CPPUNIT_FAIL("Not implemented.");
}
