/*!
  \file
  \brief SettingConfig のテスト

  \author Satofumi KAMIMURA

  $Id: TestSettingConfig.cpp 261 2009-01-22 06:48:10Z satofumi $
*/

#include "TestSettingConfig.h"
#include "SettingConfig.h"

using namespace std;


CPPUNIT_TEST_SUITE_REGISTRATION(TestSettingConfig);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestSettingConfig, "TestSettingConfig");


void TestSettingConfig::loadTest(void) {

  // 読み出し
  SettingConfig config("../theme/lm_tc.xml");

  // ベース画像
  CPPUNIT_ASSERT_EQUAL(string("base"),
                       string(config.getValue("base/base_org")));

  // アナログ部品
  CPPUNIT_ASSERT_EQUAL(string("hari_h"),
                       string(config.getValue("analog/hari_h")));
  CPPUNIT_ASSERT_EQUAL(string("hari_m"),
                       string(config.getValue("analog/hari_m")));
  CPPUNIT_ASSERT_EQUAL(string("hari_s"),
                       string(config.getValue("analog/hari_s")));

  CPPUNIT_ASSERT_EQUAL(string("on"),
                       string(config.getValue("analog/sec")));

  CPPUNIT_ASSERT_EQUAL(string("71"),
                       string(config.getValue("analog/h_xpos")));
  CPPUNIT_ASSERT_EQUAL(string("71"),
                       string(config.getValue("analog/h_ypos")));
  CPPUNIT_ASSERT_EQUAL(string("71"),
                       string(config.getValue("analog/m_xpos")));
  CPPUNIT_ASSERT_EQUAL(string("71"),
                       string(config.getValue("analog/m_ypos")));
  CPPUNIT_ASSERT_EQUAL(string("71"),
                       string(config.getValue("analog/s_xpos")));
  CPPUNIT_ASSERT_EQUAL(string("71"),
                       string(config.getValue("analog/s_ypos")));

  // デジタル部品
  CPPUNIT_ASSERT_EQUAL(string("digital"),
                       string(config.getValue("digital/parts")));
  CPPUNIT_ASSERT_EQUAL(string("on"),
                       string(config.getValue("digital/sec")));

  CPPUNIT_ASSERT_EQUAL(string("8"),
                       string(config.getValue("digital/ap_xpos")));
  CPPUNIT_ASSERT_EQUAL(string("150"),
                       string(config.getValue("digital/ap_ypos")));
  CPPUNIT_ASSERT_EQUAL(string("22"),
                       string(config.getValue("digital/h1_xpos")));
  CPPUNIT_ASSERT_EQUAL(string("150"),
                       string(config.getValue("digital/h1_ypos")));
  CPPUNIT_ASSERT_EQUAL(string("36"),
                       string(config.getValue("digital/h2_xpos")));
  CPPUNIT_ASSERT_EQUAL(string("150"),
                       string(config.getValue("digital/h2_ypos")));
  CPPUNIT_ASSERT_EQUAL(string("50"),
                       string(config.getValue("digital/cl_xpos")));
  CPPUNIT_ASSERT_EQUAL(string("150"),
                       string(config.getValue("digital/cl_ypos")));
  CPPUNIT_ASSERT_EQUAL(string("64"),
                       string(config.getValue("digital/m1_xpos")));
  CPPUNIT_ASSERT_EQUAL(string("150"),
                       string(config.getValue("digital/m1_ypos")));
  CPPUNIT_ASSERT_EQUAL(string("78"),
                       string(config.getValue("digital/m2_xpos")));
  CPPUNIT_ASSERT_EQUAL(string("150"),
                       string(config.getValue("digital/m2_ypos")));
  CPPUNIT_ASSERT_EQUAL(string("100"),
                       string(config.getValue("digital/s1_xpos")));
  CPPUNIT_ASSERT_EQUAL(string("150"),
                       string(config.getValue("digital/s1_ypos")));
  CPPUNIT_ASSERT_EQUAL(string("114"),
                       string(config.getValue("digital/s2_xpos")));
  CPPUNIT_ASSERT_EQUAL(string("150"),
                       string(config.getValue("digital/s2_ypos")));
}


void TestSettingConfig::saveTest(void) {

  // デフォルト値で保存
  SettingConfig config("save_setting_sample.txt");
  config.save();

  // !!!

  //出力できることを確認したので、よいことにする
  //CPPUNIT_FAIL("Not implemented.");
}
