/*!
  \file
  \brief TestGenerateConfigHandler のテスト

  \author Satofumi KAMIMURA

  $Id: TestGenerateConfigHandler.cpp 261 2009-01-22 06:48:10Z satofumi $
*/

#include <QString>
#include "TestGenerateConfigHandler.h"
#include "GenerateConfigHandler.h"
#include "PartsConfig.h"

using namespace std;


CPPUNIT_TEST_SUITE_REGISTRATION(TestGenerateConfigHandler);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestGenerateConfigHandler,
                                      "TestGenerateConfigHandler");


void TestGenerateConfigHandler::loadTest(void) {

  GenerateConfigHandler config;
  bool is_loaded =
    config.load("../qtmclock_src/parts_generator/parts_config.txt");
  CPPUNIT_ASSERT_EQUAL(true, is_loaded);

  // 出力フォーマットの種類が読み出せたかのテスト
  size_t size = config.size();
  CPPUNIT_ASSERT_EQUAL(4, static_cast<int>(size));

  // 時計文字用のデータが読み出せたかのテスト
  const PartsConfig digital = config.getPartsConfig(0);
  CPPUNIT_ASSERT_EQUAL(string("Akubin"), digital.font_name);
  // !!! フォントサイズ
  // !!! 文字色
  // !!! 背景色
  CPPUNIT_ASSERT_EQUAL(8, static_cast<int>(digital.offset));
  CPPUNIT_ASSERT_EQUAL(14, static_cast<int>(digital.tags.size()));
  CPPUNIT_ASSERT_EQUAL(string("0"), digital.tags[0].toStdString());
  CPPUNIT_ASSERT_EQUAL(string("P"), digital.tags[13].toStdString());

  // セパレータ用のデータが読み出せたかのテスト
  PartsConfig separator = config.getPartsConfig(3);
  CPPUNIT_ASSERT_EQUAL(string("Akubin"), separator.font_name);
  // !!! フォントサイズ
  // !!! 文字色
  // !!! 背景色
  CPPUNIT_ASSERT_EQUAL(8, static_cast<int>(separator.offset));
  CPPUNIT_ASSERT_EQUAL(2, static_cast<int>(separator.tags.size()));
  //CPPUNIT_ASSERT(! QString("時").compare(separator.tags[0]));
  //CPPUNIT_ASSERT(! QString("分").compare(separator.tags[1]));
}


#if 0
void TestGenerateConfigHandler::saveTest(void) {

  // 保持している情報を別名でファイル出力し、オリジナルと比較する
  // !!!

  CPPUNIT_FAIL("Not implemented.");
}
#endif
