#ifndef RRDA_ENCODER_H
#define RRDA_ENCODER_H

/*!
  \file
  \brief RRDA リソースのエンコード

  \author Satofumi KAMIMURA

  $Id: RrdaEncoder.h 276 2009-10-22 03:44:32Z satofumi $
*/

#include <vector>
#include <string>
#include <memory>

class RrdaResource;


/*!
  \brief RRDA リソースのエンコード
*/
class RrdaEncoder
{
public:
  /*!
    \brief コンストラクタ

    \param[in] fileName リソースファイル
    \param[in] key キー
  */
  explicit RrdaEncoder(const char* fileName, const char* key);
  ~RrdaEncoder(void);


  /*!
    \brief エラー文字列の取得

    \return エラー文字列
  */
  const char* what(void) const;


  /*!
    \brief リソース名の一覧を返す

    \return リソース名の一覧
  */
  void getResourceNames(std::vector<std::string>& names);


  /*!
    \brief リソースを返す

    \param[in] resource_name リソース名

    \return RrdaResouce オブジェクト
  */
  RrdaResource* getResource(const char* resource_name);

private:
  RrdaEncoder(void);
  RrdaEncoder(const RrdaEncoder& rhs);
  RrdaEncoder& operator = (const RrdaEncoder& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !RRDA_ENCODER_H */
