#ifndef SETTING_DIALOG_FORM_H
#define SETTING_DIALOG_FORM_H

/*!
  \file
  \brief テーマ時計の設定ダイアログ

  \author Satofumi KAMIMURA

  $Id: ClockSettingDialog.h 288 2012-06-15 13:16:21Z satofumi $
*/

#include "ui_ClockSettingDialogForm.h"
#include <memory>


/*!
  \brief テーマ時計の設定ダイアログ
*/
class ClockSettingDialog : public QDialog, private Ui::ClockSettingDialog
{
  Q_OBJECT;

 public:
  /*!
    \brief コンストラクタ

    \param[in] parent 親ウィジット
  */
  explicit ClockSettingDialog(QDialog* parent = 0);
  ~ClockSettingDialog(void);


  /*!
    \brief 拡大率のスライドバーを設定

    \param[in] value スライドバーの値
  */
  void setScalingPercent(int value);

  void setPlaceTopChecked(bool checked);

  /*!
    \brief アニメーション しない / する を設定

    \param[in] checked アニメーションしないときに true
   */
  void setNoAnimationCheckbox(bool checked);


signals:
  /*!
    \brief 拡大率の変更

    \param[out] percent 拡大率 [%]
  */
  void scalingValueChanged(int percent);

  /*!
    \brief アニメーション しない / する の変更

    \param[in] checked アニメーションしないときに true が渡される
  */
  void noAnimationStateChanged(bool checked);

  void placeTopChanged(bool checked);

private slots:
  void scalingSliderHandler(int value);
  void noAnimationCheckboxHandler(bool checked);

private:
  ClockSettingDialog(const ClockSettingDialog& rhs);
  ClockSettingDialog& operator = (const ClockSettingDialog& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !SETTING_DIALOG_FORM_H */
