/*!
  \file
  \brief テーマ時計の設定ダイアログ

  \author Satofumi KAMIMURA

  $Id: ClockSettingDialog.cpp 293 2012-06-27 13:16:02Z satofumi $

  \todo アニメーションできないならば、disable にする
*/

#include "ClockSettingDialog.h"


struct ClockSettingDialog::pImpl
{
  void initializeForm(ClockSettingDialog* parent)
  {
    // !!! とりあえず、隠しておく
    parent->no_animation_checkbox_->hide();

    // アイコンの適用
    parent->setWindowIcon(QIcon(":icons/qtmclock_icon"));

    // 拡大率の変更
    connect(parent->scale_slider_, SIGNAL(valueChanged(int)),
            parent, SLOT(scalingSliderHandler(int)));

    // アニメーション設定の変更
    connect(parent->no_animation_checkbox_, SIGNAL(clicked(bool)),
            parent, SLOT(noAnimationCheckboxHandler(bool)));

    connect(parent->top_checkbox_, SIGNAL(toggled(bool)),
            parent, SIGNAL(placeTopChanged(bool)));
  }
};


ClockSettingDialog::ClockSettingDialog(QDialog* parent)
  : QDialog(parent), pimpl(new pImpl)
{
  setupUi(this);
  pimpl->initializeForm(this);
}


ClockSettingDialog::~ClockSettingDialog(void)
{
}


void ClockSettingDialog::scalingSliderHandler(int value)
{
  scale_percent_label_->setText(QString(tr("%1 %")).arg(value));
  emit scalingValueChanged(value);
}


void ClockSettingDialog::noAnimationCheckboxHandler(bool checked)
{
  emit noAnimationStateChanged(checked);
}


void ClockSettingDialog::setScalingPercent(int value)
{
  scale_slider_->setValue(value);
}


void ClockSettingDialog::setPlaceTopChecked(bool checked)
{
  top_checkbox_->setChecked(checked);
}


void ClockSettingDialog::setNoAnimationCheckbox(bool checked)
{
  no_animation_checkbox_->setChecked(checked);
}
