#ifndef CLOCK_PARTS_DRAW_H
#define CLOCK_PARTS_DRAW_H

/*!
  \file
  \brief テーマ時計の部品描画

  \author Satofumi KAMIMURA

  $Id: ClockPartsDraw.h 261 2009-01-22 06:48:10Z satofumi $
*/

#include <QVector>

class QPainter;
class QPoint;
class QRegion;
class ThemeResource;


namespace ClockPartsDraw
{
  enum {
    InvalidCellIndex = -1,      //!< 無効なセル番号
    NoAnimationCell = -2,       //!< セルを描画しない場合
  };

  /*!
    \brief テーマ時計の再描画を行う

    \param[out] region 描画 Pixel マスク領域の和
    \param[in] resource 描画リソース
    \param[in] digital_positions デジタル部品の描画位置
    \param[in] calendar_positions カレンダー部品の表示位置
    \param[in] scaling_percent 拡大率 [%]
    \param[in] sec_offset 描画時の秒オフセット [sec]
  */
  extern void updatePixmaps(QRegion& region,
                            const ThemeResource& resource,
                            const QVector<QPoint>& digital_positions,
                            const QVector<QPoint>& calendar_positions,
                            size_t scaling_percent = 100, int sec_offset = 0,
                            int cell_index = InvalidCellIndex);

  /*!
    \brief Pixel 画像の描画

    \param[in] painter 描画対象
  */
  extern void drawPixmaps(QPainter& painter, bool force_draw = false);
}

#endif /* !CLOCK_PARTS_DRAW_H */
