<?php
/*!
  \file
  \brief α

  \author Satofumi KAMIMURA

  $Id$
*/

require_once('config.php');
require_once('AccessBbsData.php');

define('PAGE_ARTICLE_NUM', 6);


// åɾκ
function echoThreadText($thread)
{
  if (count($thread) <= 0) {
    print <<<EOB
<div id="bbs_thread">
<ul>
<li>åɤʤ</li>
</ul>
</div>
EOB;
  } else {
    // !!!
  }
}


// ɽ
function echoArticles($articles)
{
  if (count($articles) <= 0) {
    print <<<EOB
<div id="bbs_article">
<ul>
<li>Ƥʤ</li>
</ul>
</div>
EOB;
  } else {
    print '<div id="bbs_article">';
    foreach ($articles as $each_thread) {
      // !!! ...
      $i = 0;
      $n = count($each_thread);

      // ˤäơȤդ롣ϡƤ˳ȤդƤ
      if ($n > 0) {
        print '<table width="100%"><tr><td>';
      }
      foreach ($each_thread as $each_article) {
        echo $text = bbs_createArticleTable($each_article);
        if ($text != '') {
          if ($i != ($n - 1)) {
            echo '<br>';
          }
        }
        ++$i;
      }
      if ($n > 0) {
        print '</td></tr></table>';
        print '<br>';
      }
    }
    print '</div>';
  }
}


function bbs_header() {

  // ǡ١³
  $db = new AccessDatabase(DB_HOST, DB_NAME, DB_USER, DB_PASSWORD);
  if (! $db->connect()) {
    // !!! 顼åɽ
    return;
  }
  mysql_query("SET NAMES ujis");

  // ɽڡμ
  $page = 0;
  if (isset($_GET['page'])) {
    $page = intval($_GET['page']);
  }

  // κ
  if (isset($_POST['remove']) &&
      isset($_POST['article_id']) &&
      isset($_POST['delete_key'])) {
    $delete_key = $_POST['delete_key'];
    $article_id = intval($_POST['article_id']);
    $db->deleteArticle($article_id, $delete_key);

    header('Location: bbs.php');
  }

  $test_article = bbs_parseCommitted($_POST);

  if (isset($_POST['test'])) {
    // ƥƤξ硢ξ
    $commit_key = $test_article['commit_key'];

  } else if (isset($_POST['submit']) &&
             (! isset($test_article['error_message']))) {
    // Ƥξ硢Ͽ
    $db->commitArticle($test_article);
    header('Location: bbs.php');

  } else if (isset($_GET['id'])) {
    // Reply ξ硢εѤϥե
    $commit_key = $db->getCommitKey();
    $id = intval($_GET['id']);
    $test_article = $db->getReplyArticle($id, $_POST);

  } else {
    // ̾α
    $test_article = array();
    $test_article['error_message'] = '';

    // ƥफ饭
    $commit_key = $db->getCommitKey();
  }

  // åɾμ
  $threads = $db->getThreadList();

  // ڡμ
  $page_max = $db->getPageMax();

  // μ
  list($articles, $page_max) = $db->getArticles($page, PAGE_ARTICLE_NUM);

  return array($db, $articles, $page_max, $commit_key, $test_article, $page);
}


function bbs_body($args) {

  list($db, $articles, $page_max, $commit_key, $test_article, $page) = $args;
  print '<div id="bbs">';
  print '<a name="bbs_top"></a>';

  // _GET[], _POST[] ξΤߡǶν񤭹ߤɽ
  if ((count($_POST) == 0) && (count($_GET) == 0)) {
    $recent_articles = $db->getRecentArticlesAbst(3);
    if (count($recent_articles) > 0) {
      print 'Ƕν񤭹';
      print '<ul>';

      foreach ($recent_articles as $article) {
        $id = $article['id'];
        print '<li>'. $article['datetime'].
          '&nbsp; <b>'. $article['name']. '</b> &nbsp;<a href="#'. $id. '">'. $article['title']. '</a></li>';
      }

      print '</ul><br>';
    }
  }

  // ƥƤƤȡ顼åɽ
  if (isset($_POST['test']) || isset($_GET['id'])) {
    print '<div id="bbs_article">';
    echo bbs_createArticleTable($test_article);
    print '<br></div>';

    if (isset($test_article['error_message'])) {
      echo htmlspecialchars($test_article['error_message'], ENT_QUOTES);
    }
  }

  // ƥեɽ
  $valid = isset($test_article['error_message']) ? false : true;
  echo bbs_commitForm($commit_key, $test_article, $valid, $page);

  echo '<br>';

  // ɽ
  echoArticles($articles);

  // ڡѥ󥯤ɽ
  echo bbs_createPageLink($page_max);
}


// ƥեɽ
function bbs_commitForm($commit_key, $default = array(), $valid = false,
                        $page = 0)
{
  // !!! ѥѥɤˤϡ"ѿ(ʸ)" ʤ󤫤Υǥեɽ򤷤

  $disabled = (! $valid) ? 'disabled' : '';

  $tag_array = array('name', 'title', 'message', 'pass');
  $tag = array();
  foreach ($tag_array as $key) {
    // ̾μФ
    if (isset($default[$key])) {
      $tag[$key] = htmlspecialchars($default[$key], ENT_QUOTES);
    } else {
      $tag[$key] = '';
    }
  }
  $name = $tag['name'];
  $title = $tag['title'];
  $message = $tag['message'];
  $pass = $tag['pass'];
  $commit_key = htmlspecialchars($commit_key, ENT_QUOTES);
  $parent_id = isset($default['parent_id']) ? intval($default['parent_id']) : 0;
  $page = intval($page);

  $output = <<<EOB
<div id="bbs_commit">
<form method="post" action="#bbs_top?page=$page">
<table width="100%">
<tr><th>Name</th><td><input type="text" name="name" value="$name" size="16"></input></td></tr>
<tr><th>Title</th><td><input type="text" name="title" value="$title" size="32"></input></td></tr>
<tr><th>Message</th><td><textarea name="message" rows="4" cols="40" value="$message">$message</textarea></td></tr>
<tr><th>Pass</th><td><input type="password" name="pass" value="$pass" size="8"></input>
<input type="submit" name="test" value="ƥ">
<input type="submit" name="submit" value="񤭹" $disabled>
</td></tr>
</table>
<input type="hidden" name="commit_key" value="$commit_key">
<input type="hidden" name="parent_id" value="$parent_id">
</form>
</div>
EOB;

  return $output;
}


function bbs_parseCommitted($post)
{
  $article = array();

  if ((! isset($post['submit'])) && (! isset($post['test']))) {
    // Ƥʤ
    $article['error_message'] = 'O.K.';
    return $article;
  }

  $error_message = '';

  // !!! foreach Ǥޤ魯٤

  // ̾γǼ
  if (isset($post['name']) && strlen($post['name'])) {
    $article['name'] = $post['name'];
  } else {
    $error_message .= "̾ϤƤޤ";
    $article['name'] = '';
  }

  // ȥγǼ
  if (isset($post['title']) && strlen($post['title'])) {
    $article['title'] = $post['title'];
  } else {
    $error_message .= "ȥ뤬ϤƤޤ";
    $article['title'] = '';
  }

  // åγǼ
  if (isset($post['message']) && strlen($post['message'])) {
    $article['message'] = $post['message'];
  } else {
    $error_message .= "åޤ";
    $article['message'] = '';
  }

  // ѥγǼ
  if (isset($post['pass'])) {
    $article['pass'] = $post['pass'];
  } else {
    // ѥʤƤ⡢ƤĤ
  }

  // γǼ
  if (isset($post['commit_key'])) {
    $article['commit_key'] = $post['commit_key'];
  } else {
    $error_message .= " ";
    $article['commit_key'] = '';
  }

  // parend_id γǼ
  if (isset($post['parent_id'])) {
    $article['parent_id'] = $post['parent_id'];
  }

  // 顼åСɲä
  if (strlen($error_message) > 0) {
    $article['error_message'] = $error_message;
  }

  return $article;
}


// ɽơ֥
function bbs_createArticleTable($article, $page = 0)
{
  foreach ($article as $key => $value) {
    $article[$key] = htmlspecialchars($value, ENT_QUOTES);
  }

  if (! isset($article['time'])) {
    $article['time'] = time();
  }
  $date = date("Y-m-d", $article['time']);
  $time = date("H:i", $article['time']);
  $title = $article['title'];
  $message = str_replace("\n", "<br>\n", trim($article['message']));
  $name = $article['name'];
  $id = isset($article['article_id']) ? $article['article_id'] : ' TEST ';
  $page = intval($page);
  if (isset($article['depth'])) {
    $width = 97 - intval($article['depth']) * 5;
  } else {
    $width = 97;
  }

  $output = <<<EOB
<a name="$id"></a>
<div align="right">
<table width="$width%">
<tr><th width="60%" align="left">$title</th><th class="reply" width="35%" align="center">$date &nbsp;$time</th><th class="reply" width="5%" align="center"><a href="bbs.php?id=$id&page=$page">Reply</a></th></tr>
<tr><td colspan="3"><b>$name</b><br>$message<br><br><div align="right">[$id]</a></td></tr>
</table>
</div>
EOB;
  return $output;
}

function bbs_createRemoveForm() {
  $output = <<<EOB
<form method="POST" action="">
<table>
<tr><th>Message ID</th><td><input type="text" name="article_id" size="4"></input></td></tr>
<tr><th>Pass</th><td><input type="password" name="delete_key" size="8"></input>
<input type="submit" name="remove" value=""></td></tr>
</table>
</form>
EOB;

  return $output;
}

// ڡ󥯤κ
function bbs_createPageLink($page_max)
{
  $output = '<div id="bbs_pagelink">Page. ';
  for ($i = 0; $i <= $page_max; ++$i) {
    $output .= '<a href="bbs.php?page='. $i. '">['. ($i + 1). ']</a> ';
  }
  $output .= '</div>';
  return $output;
}
