/* MemoryPool.h */
/* 2008/11/05   */

#pragma once

/* MemoryPool */
struct MemoryPool {

	VOID*  Block;
	SIZE_T TotalSize;

	VOID*  Backyard;
	SIZE_T BackyardSize;
	SIZE_T MaxBackyardSize;

}; /* MemoryPool */

typedef struct MemoryPool MemoryPool_t;

/* */

void QV_MemoryPool_Init(
	MemoryPool_t* t);

void QV_MemoryPool_Release(
	MemoryPool_t* t);

void* QV_MemoryPool_Allocate(
	MemoryPool_t* t,
	SIZE_T        cb);

/* */

VOID* QV_MemoryPool_EnterBackyard(
	MemoryPool_t* t);

void QV_MemoryPool_LeaveBackyard(
	MemoryPool_t* t,
	VOID*         ctx);

VOID* QV_MemoryPool_AllocateBackyard(
	MemoryPool_t* t,
	SIZE_T        cb);

/* */

