/* HuffmanDecoder.h */
/* 2008/11/05       */

#pragma once

#include "DecoderContext.h"

#include "BitDecoder.h"

/* */

struct VHuffmanDecoder;

typedef struct VHuffmanDecoder HuffmanDecoder_t;

typedef INT32 (*HuffmanLookup_t)(const HuffmanDecoder_t*, BitDecoder_t*);

/* VHuffmanDecoder */
struct VHuffmanDecoder {

	UINT8  Length[32];
	UINT16 CodeCount[32];

	UINT32* CodeWord;
	UINT16* Index;

	INT32 Dimensions;
	INT32 Entries;

	INT32 IndexCount;

	FLOAT* Lookup;

	INT32   LookupBits;
	UINT16* CodeLookup;
	INT32   NextCode;
	INT32   NextStart;

	HuffmanLookup_t LookupFunc;

}; /* VHuffmanDecoder */

/* */

BOOL QV_HuffmanDeocder_Setup(
	DecoderContext_t* ctx,
	BitDecoder_t*     d,
	HuffmanDecoder_t* huff);

/*
INT32 QV_HuffmanDecoder_Lookup(
	const HuffmanDecoder_t* huff,
	BitDecoder_t*           d);
*/

#define QV_HuffmanDecoder_Lookup(h, d) (((h)->LookupFunc)((h), d))

/* */

INT32 QV_HuffmanDecoder_LookupTable_SSE2(
	const HuffmanDecoder_t* h,
	BitDecoder_t*           d);

/* */

