/* CSConverter.c */
/* 2009/06/19    */

#include "StdAfx.h"

#include "TheoraDecoder.h"

#include "CSConverter.h"

/* */

void QT_CSConvert_YV12(
	const QT_Output_t* output,
	QT_Frame_t*        frame)
{
	UINT8* pb0 = (UINT8*)(frame->Frame);
	UINT8* pb1 = pb0 + frame->Rasters * frame->Pitch;
	UINT8* pb2 = pb1 + frame->Rasters * frame->Pitch / 4;
	UINT8* end;

	INT32 r0 = output->CY - frame->Y;

	const UINT8* s0 = output->Plane[0] + frame->X + (r0     - 1) * output->CX;
	const UINT8* s1 = output->Plane[2] + frame->X + (r0 / 2 - 1) * output->CX / 2;
	const UINT8* s2 = output->Plane[1] + frame->X + (r0 / 2 - 1) * output->CX / 2;

	end = pb0 + frame->CY * frame->Pitch;
	while (pb0 < end) {
		memcpy(pb0, s0, frame->CX);
		pb0 += frame->Pitch;
		s0  -= output->CX;
	}

	end = pb1 + (frame->CY / 2) * (frame->Pitch / 2);
	while (pb1 < end) {
		memcpy(pb1, s1, frame->CX / 2);
		pb1 += frame->Pitch / 2;
		s1  -= output->CX / 2;
	}

	end = pb2 + (frame->CY / 2) * (frame->Pitch / 2);
	while (pb2 < end) {
		memcpy(pb2, s2, frame->CX / 2);
		pb2 += frame->Pitch / 2;
		s2  -= output->CX / 2;
	}
}

void QT_CSConvert_YUY2(
	const QT_Output_t* output,
	QT_Frame_t*        frame)
{
	UINT8* pb  = (UINT8*)(frame->Frame);
	UINT8* end = pb + frame->CY * frame->Pitch;

	INT32 r0 = output->CY - frame->Y;

	const UINT8* s0 = output->Plane[0] + frame->X + (r0     - 1) * output->CX;
	const UINT8* s1 = output->Plane[1] + frame->X + (r0 / 2 - 1) * output->CX / 2;
	const UINT8* s2 = output->Plane[2] + frame->X + (r0 / 2 - 1) * output->CX / 2;

	for (; pb < end; pb += frame->Pitch * 2, s0 -= output->CX * 2, s1 -= output->CX / 2, s2 -= output->CX / 2) {
		UINT8* pb0 = pb;
		UINT8* pb1 = pb + frame->Pitch;
		UINT8* pe0 = pb + frame->CX * 2;

		const UINT8* y0 = s0;
		const UINT8* y1 = s0 - output->CX;
		const UINT8* u  = s1;
		const UINT8* v  = s2;

		for (; pb0 < pe0; pb0 += 4, pb1 += 4, y0 += 2, y1 += 2, u++, v++) {
			pb0[0] = y0[0];
			pb0[1] = u [0];
			pb0[2] = y0[1];
			pb0[3] = v [0];

			pb1[0] = y1[0];
			pb1[1] = u [0];
			pb1[2] = y1[1];
			pb1[3] = v [0];
		}
	}
}

/* */

