/* Utils.h    */
/* 2009/05/21 */

#pragma once

#include "MemoryAllocator.h"

#include "StreamReader.h"

/* */

QM_Allocator_t* Allocator_Get();

/* */

void QM_StreamReader_Init(
	QM_StreamReader_t* t,
	FILE*              fp);

void QM_StreamReader_IStream(
	QM_StreamReader_t* t,
	IStream*           p);

/* */

/* QM_MemoryPool */
struct QM_MemoryPool {

	VOID*  Block;
	SIZE_T TotalSize;

}; /* QM_MemoryPool */

typedef struct QM_MemoryPool QM_MemoryPool_t;

/* */

void QM_MemoryPool_Init(
	QM_MemoryPool_t* t);

void QM_MemoryPool_Release(
	QM_MemoryPool_t* t,
	QM_Allocator_t*  alloc);

VOID* QM_MemoryPool_Allocate(
	QM_MemoryPool_t* t,
	QM_Allocator_t*  alloc,
	SIZE_T           cb);

/* */

