// QDecoder.cpp
// 2009/05/29

#include "StdAfx.h"

#include <initguid.h>

#include "Matroska.h"
#include "TheoraDecoder.h"
#include "VorbisDecoder.h"

#include "QDecoder.h"

#include "QBase.h"

#include "QImageConverter.h"
#include "QWaveOutputer.h"

#include "QReader.h"

#include "QMediaType.h"

#include "QPinEnum.h"

#include "QStreamer.h"

#include "QPin.h"
#include "QPinVideo.h"
#include "QPinAudio.h"

#include "QFilter.h"

/* */

HRESULT QD_CreateDecoder(
	LPCWSTR       path,
	IBaseFilter** ppFilter)
{
	ATL::CComObject<QFilter>* filter = 0;
	HRESULT hRslt = ATL::CComObject<QFilter>::CreateInstance(&filter);
	if (FAILED(hRslt)) {
		return hRslt;
	}

	hRslt = filter->Open(path);
	if (FAILED(hRslt)) {
		delete filter;
		return hRslt;
	}

	hRslt = filter->QueryInterface(ppFilter);
	if (FAILED(hRslt)) {
		delete filter;
		return hRslt;
	}

	return S_OK;
}

/* */

HRESULT QD_CreateDecoder_IStream(
	IStream*      p,
	IBaseFilter** ppFilter)
{
	ATL::CComObject<QFilter>* filter = 0;
	HRESULT hRslt = ATL::CComObject<QFilter>::CreateInstance(&filter);
	if (FAILED(hRslt)) {
		return hRslt;
	}

	hRslt = filter->Open(p);
	if (FAILED(hRslt)) {
		delete filter;
		return hRslt;
	}

	hRslt = filter->QueryInterface(ppFilter);
	if (FAILED(hRslt)) {
		delete filter;
		return hRslt;
	}

	return S_OK;
}

/* */

void QD_FreeMediaType(
	AM_MEDIA_TYPE* mt)
{
	QMediaType::Free(mt);
}

/* */

