#include "stdafx.h"
#include "BaseFace.h"



namespace lib_geo
{


void BaseFace::ClearAdjBuffer(void)
{
	m_AdjEids.clear();
}

size_t BaseFace::NumVertices(void) const
{
	return m_VertIds.size();
}

size_t BaseFace::NumTriangles(void) const
{
	size_t num_verts = m_VertIds.size();
	if (num_verts < 3)
		return 0;
	return num_verts - 2;
}

// ʒuȊO̗vfĂ邩mF.
bool BaseFace::HasNormal(void) const
{
	return !m_NormIds.empty();
}

bool BaseFace::HasUV(void) const
{
	return !m_UVIds.empty();
}

bool BaseFace::VerifyElementCounts(void) const
{
	// _IDɑp`\. ̗vf͊p̑\
	if( m_VertIds.empty() )
	{
		if( !m_NormIds.empty() ) return false;
		if( !m_UVIds.empty()   ) return false;
	}
	else
	{
		if( !m_NormIds.empty() )
		{
			if( m_VertIds.size() != m_NormIds.size() ) return false;
			if( m_UVIds.size() != m_UVIds.size() ) return false;
		}
	}

	return true;
}

void BaseFace::CopySubTriangle(BaseFace& f, int lvid0, int lvid1, int lvid2) const
{
	f.m_MatIdx = m_MatIdx;

	f.m_VertIds.resize(3);
	f.m_VertIds[0] = m_VertIds[lvid0];
	f.m_VertIds[1] = m_VertIds[lvid1];
	f.m_VertIds[2] = m_VertIds[lvid2];

	if (!m_NormIds.empty())
	{
		f.m_NormIds.resize(3);
		f.m_NormIds[0] = m_NormIds[lvid0];
		f.m_NormIds[1] = m_NormIds[lvid1];
		f.m_NormIds[2] = m_NormIds[lvid2];
	}

	if (!m_UVIds.empty())
	{
		f.m_UVIds.resize(3);
		f.m_UVIds[0] = m_UVIds[lvid0];
		f.m_UVIds[1] = m_UVIds[lvid1];
		f.m_UVIds[2] = m_UVIds[lvid2];
	}
}

void BaseFace::FlipIndexBuf(void)
{
	std::reverse(m_VertIds.begin(), m_VertIds.end());
	std::reverse(m_NormIds.begin(), m_NormIds.end());
	std::reverse(m_UVIds.begin(), m_UVIds.end());
	std::reverse(m_AdjEids.begin(), m_AdjEids.end());
}


}
