#pragma once

#include <C2/lm/vector3.h>

#include "BaseMeshPrimitives.h"



namespace lib_geo
{


class BaryCoord
{
public:
	BaryCoord(void)
	{
	}

	BaryCoord(int fid, int subface, const lm::vec3f& bc) :
		Subface(fid, subface),
		Bary(bc)
	{
	}

	void Set(int fid, int subface, const lm::vec3f& bc)
	{
		Subface.Set(fid, subface);
		Bary = bc;
	}

	void Reset(void)
	{
		Subface.Reset();
		Bary.set(0.0f, 0.0f, 0.0f);
	}

	bool IsValid(void) const
	{
		return Subface.IsValid();
	}

	void SetMidSubface(const lib_geo::SubfaceIdx& subf)
	{
		float mid = 1.0f / 3.0f;
		Bary.set(mid, mid, mid);
		Subface = subf;
	}

public:
	lib_geo::SubfaceIdx Subface;
	lm::vec3f Bary;
};


}
