#pragma once

#include <C2/graph/Color.h>
#include <C2/lm/range3.h>

#include "ShaderLibrary.h"
#include "PostprocLibrary.h"

#include <LibQtGeoViewerCore/CrossSectionConfig.h>
#include <LibQtGeoViewerCore/NamedValue.h>



class View3DConfig
{
public:
	View3DConfig(void)
	{
		m_DrawFace            .Reset( true  , "DrawFace"           );
		m_DrawWire            .Reset( false , "DrawWire"           );
		m_DrawVert            .Reset( false , "DrawVert"           );
		m_EnableVertexColor   .Reset( false , "EnableVertexColor"  );
		m_VertColorTo01       .Reset( false , "VertColorTo01"      );
		m_DrawPolyline        .Reset( true  , "DrawPolyline"       );
		m_DrawPolylineIdx     .Reset( true  , "DrawPolylineIdx"    );
		m_DrawPolylineLen     .Reset( false , "DrawPolylineLen"    );
		m_DrawPolylineLenWhl  .Reset( false , "DrawPolylineLenWhl" );
		m_DrawVid             .Reset( false , "DrawVid"            );
		m_ShowSelVertCoord    .Reset( false , "DrawSelVertCoord"   );
		m_ShowSelVertIdx      .Reset( false , "DrawSelVertIdx"     );
		m_ShowMeshBound       .Reset( false , "ShowMeshBound"      );
		m_DrawFid             .Reset( false , "DrawFid"            );
		m_DrawBBox            .Reset( false , "DrawBBox"           );
		m_DrawBBoxRange       .Reset( false , "DrawBBoxRange"      );
		m_DrawVertNormal      .Reset( false , "DrawVertNormal"     );
		m_ShowVidTopMost      .Reset( false , "IndexTopMost"       );
		m_DrawBone            .Reset( false , "DrawBone"           );

		m_EnableLighting      .Reset( true  , "Lighting"           );
		m_LightIsDirectional  .Reset( true  , "DirectionalLight"   );
		m_EnableTexture       .Reset( true  , "DrawTexture"        );
		m_EnableFlatShade     .Reset( false , "FlatShading"        );
		m_EnableCullFace      .Reset( false , "CullFace"           );
		m_DoubleSideShading   .Reset( false , "DoubleSideLighting" );
		m_CullAngle_F         .Reset( true  , "CullFore"           );
		m_EnableCoverageTrans .Reset( false , "CVTransparent"      );
		m_SeparateSpecular    .Reset( true  , "SeparateSpecular"   );
		m_UseFixMaterial      = false;
		m_IndexMaterial       = false;
		m_FBMaterial          = false;
		m_UseFixTexture       = false;
		m_EnableMultisample   = false;

		m_DrawAxis          .Reset( true  , "Axis"          );
		m_DrawMiniAxis      .Reset( true  , "MiniAxis"      );
		m_DrawGround        .Reset( true  , "Grid"          );
		m_DrawLightPosition .Reset( true  , "LightPos"      );
		m_DrawLookPos       .Reset( false , "LookPos"       );
		m_DrawCameraMeasure .Reset( false , "CameraMeasure" );
		m_DrawShadowmapBuf  = false;

		m_HighlightSelected     .Reset( false , "HighlihgtSelect"         );
		m_HighlightSelectedWire .Reset( false , "m_HighlightSelectedWire" );
		m_HighlightMaterial     .Reset( false , "HilightMaterial"         );
		m_ShowOnlySelect        .Reset( false , "ShowOnlySelect"          );

		m_EnableWireDispList .Reset( false , "WireDispList" );
		m_EnableFaceVBO      .Reset( false , "FaceVBO"      );
		m_EnableWireVBO      .Reset( false , "WireVBO"      );

		m_ShaderMode = ShaderType::Default;
		m_PPMode     = PostProcType::None;

		m_ShowCloseVertInfo .Reset( false , "EnableAdj"       );
		m_PickTransparent   .Reset( false , "PickTransparent" );

		m_ShowRenderTime   .Reset( false , "FPS"       );
		m_DrawRenderRange  .Reset( false , "ClipRange" );
		m_DrawCameraRecord .Reset( false , "CameraLog" );

		m_SyncLightTocamera.Reset( false , "SyncLightTocamera" );

		m_FlipMouseMR.Reset(false, "FlipMouseMR");

		m_WireColor.set(255, 0, 0);

		m_PointSize = 3;
		m_NormalLength = 0.04f;
		m_IndexLineLen = 0.05f;
	}

public:
	NamedValue<bool> m_DrawFace;
	NamedValue<bool> m_DrawWire;
	NamedValue<bool> m_DrawVert;
	NamedValue<bool> m_EnableVertexColor;
	NamedValue<bool> m_VertColorTo01;
	NamedValue<bool> m_DrawPolyline;
	NamedValue<bool> m_DrawPolylineIdx;
	NamedValue<bool> m_DrawPolylineLen;
	NamedValue<bool> m_DrawPolylineLenWhl;
	NamedValue<bool> m_DrawVid;
	NamedValue<bool> m_ShowSelVertCoord;
	NamedValue<bool> m_ShowSelVertIdx;
	NamedValue<bool> m_ShowMeshBound;
	NamedValue<bool> m_DrawFid;
	NamedValue<bool> m_DrawBBox;
	NamedValue<bool> m_DrawBBoxRange;
	NamedValue<bool> m_DrawVertNormal;
	NamedValue<bool> m_ShowVidTopMost;
	NamedValue<bool> m_DrawBone;

	NamedValue<bool> m_EnableLighting;
	NamedValue<bool> m_LightIsDirectional;
	NamedValue<bool> m_EnableTexture;
	NamedValue<bool> m_EnableFlatShade;
	NamedValue<bool> m_EnableCullFace;
	NamedValue<bool> m_DoubleSideShading;
	NamedValue<bool> m_CullAngle_F;
	NamedValue<bool> m_EnableCoverageTrans;
	NamedValue<bool> m_SeparateSpecular;
	bool m_UseFixMaterial;
	bool m_IndexMaterial;
	bool m_FBMaterial;
	bool m_UseFixTexture;
	bool m_EnableMultisample;

	NamedValue<bool> m_DrawAxis;
	NamedValue<bool> m_DrawMiniAxis;
	NamedValue<bool> m_DrawGround;
	NamedValue<bool> m_DrawLightPosition;
	NamedValue<bool> m_DrawLookPos;
	NamedValue<bool> m_DrawCameraMeasure;
	bool m_DrawShadowmapBuf;

	NamedValue<bool> m_HighlightSelected;
	NamedValue<bool> m_HighlightSelectedWire;
	NamedValue<bool> m_HighlightMaterial;
	NamedValue<bool> m_ShowOnlySelect;

	NamedValue<bool> m_EnableWireDispList;
	NamedValue<bool> m_EnableFaceVBO;
	NamedValue<bool> m_EnableWireVBO;

	ShaderType   m_ShaderMode;
	PostProcType m_PPMode;

	NamedValue<bool> m_ShowCloseVertInfo;
	NamedValue<bool> m_PickTransparent;

	NamedValue<bool> m_ShowRenderTime;
	NamedValue<bool> m_DrawRenderRange;
	NamedValue<bool> m_DrawCameraRecord;

	NamedValue<bool> m_SyncLightTocamera;

	NamedValue<bool> m_FlipMouseMR;

	lgr::color3b m_WireColor;

	int m_PointSize;
	float m_NormalLength;
	float m_IndexLineLen;
};
