varying vec3 v_position;

uniform sampler2D tex_color0;
uniform sampler2D tex_color1;
uniform sampler2D tex_depth;

uniform int tex_width;
uniform int tex_height;

uniform float look_depth;
uniform float pint_depth;
uniform float pint_range;



void main (void)
{
	float tx = v_position.x * 0.5 + 0.5;
	float ty = v_position.y * 0.5 + 0.5;
	vec4 uv = vec4(tx, ty, 0.0, 1.0);

	vec4 diff_x = vec4( 1.0 / tex_width , 0.0 , 0.0 , 0.0 );
	vec4 diff_y = vec4( 0.0 , 1.0 / tex_height , 0.0 , 0.0 );

	vec4 nearcolor = texture2DProj( tex_color1 , uv );

	float h = texture2DProj(tex_depth, uv).x;

	vec4 farcolor = texture2DProj( tex_color0 , uv );
	int adj = 14;
	float ad = 3.0;
	for (int i = 0; i < adj; ++i)
	{
		vec4 sx = diff_x * i;
		vec4 sy = diff_y * i;
		float dn = 1.0 * (adj-i)/(adj+1);
		float rate = dn * 0.5 + 0.5;
		farcolor += rate * texture2DProj( tex_color0 , uv + sx ) * 2.0;
		farcolor += rate * texture2DProj( tex_color0 , uv + sy ) * 2.0;
		farcolor += rate * texture2DProj( tex_color0 , uv - sx ) * 2.0;
		farcolor += rate * texture2DProj( tex_color0 , uv - sy ) * 2.0;
		farcolor += rate * texture2DProj( tex_color0 , uv + sx + sy );
		farcolor += rate * texture2DProj( tex_color0 , uv + sx - sy );
		farcolor += rate * texture2DProj( tex_color0 , uv - sx + sy );
		farcolor += rate * texture2DProj( tex_color0 , uv - sx - sy );
		ad += rate * 12.0;
	}

	farcolor /= ad;

	float depth_blend = abs(h - pint_depth) * pint_range;
	depth_blend = min(depth_blend, 1.0);

	gl_FragColor = depth_blend * farcolor + (1.0 - depth_blend) * nearcolor;

	gl_FragColor.w = 1.0;
}
