#include "StdAfx.h"
#include "CustomShader.h"


bool CustomShader::Rebuild(void)
{
	Release();

	lib_gl::GlslShader vert;
	bool suc_vert = CreateVertexShader(vert);

	m_LastVertCompileStatus = vert.GetLastCompileStatus();

	lib_gl::GlslShader frag;
	bool suc_frag = CreateFragmentShader(frag);

	m_LastFragCompileStatus = frag.GetLastCompileStatus();

	if(!suc_vert || !suc_frag)
		return false;

	if(!m_Program.Create(vert, frag))
		return false;

	return true;
}

void CustomShader::Release(void)
{
	m_Program.Release();

	m_LastVertCompileStatus.clear();
	m_LastFragCompileStatus.clear();
}

void CustomShader::BeginShader(void)
{
	m_Program.BeginShader();
}

void CustomShader::EndShader(void)
{
	m_Program.EndShader();
}


bool CustomShader::CreateVertexShader(lib_gl::GlslShader& shaer)
{
	if( !shaer.CreateFromSrc( GL_VERTEX_SHADER , m_VertCode.c_str() , m_VertCode.length() ) )
		return false;

	return true;
}

bool CustomShader::CreateFragmentShader(lib_gl::GlslShader& shaer)
{
	if( !shaer.CreateFromSrc( GL_FRAGMENT_SHADER , m_FragCode.c_str() , m_FragCode.length() ) )
		return false;

	return true;
}


void CustomShader::SetVertCode(const char* code)
{
	m_VertCode = code;
}

void CustomShader::SetFragCode(const char* code)
{
	m_FragCode = code;
}
