#include "stdafx.h"
#include "DepthColor.h"

#include "../PathInfo.h"

#include "../../GLUtility/ShaderUtil.h"



DepthColorPostproc::DepthColorPostproc(PostprocContext* context) : 
	PostprocInterface(context)
{
	QString shader_path = PathInfo::GetPostprocCodeDirPath();

	std::string p = shader_path.toLocal8Bit().data();

	std::string frag_filename = p + "DepthColor.frag";
	std::string vert_filename = p + "DepthColor.vert";

	ShaderUtil::InitShaderStd(m_Shader, frag_filename, vert_filename);
}

void DepthColorPostproc::BeginRender(void)
{
	m_Shader.BeginShader();

	SetStandardSiinglePathPPTextureConfig(m_Shader);
}

void DepthColorPostproc::EndRender(void)
{
	m_Shader.EndShader();
}
