#pragma once

#include "../SDL_Include.h"



class SampleTextureBuilder
{
public:
	enum TextureType
	{
		TEX_CHECKER,
		TEX_STRIPE_V,
		TEX_STRIPE_H,
	};

public:
	static SDL_Surface* CreateTexture(TextureType tex_type, int size);

private:
	static SDL_Surface* CreateChecker(int size);
	static SDL_Surface* CreateStripeV(int size);
	static SDL_Surface* CreateStripeH(int size);

	static SDL_Surface* CreateSquareSurface(int size);

	static void SetRGB(SDL_Surface* surface, int x, int y, int r, int g, int b);
};
