#pragma once

#include "GlTexture.h"
#include "MatcapImage.h"



namespace geom
{


class MeshBuf;


enum class TextureType
{
	None,
	Color,
	Normal,
};

class GeomTextureSet
{
public:
	GeomTextureSet(MeshBuf* parent_) :
		Parent(parent_)
	{
		TexColor  = NULL;
		TexNormal = NULL;
	}

	void ReleaseAll(void)
	{
		TexColor  = NULL;
		TexNormal = NULL;

		TexMatcap.ClearEnv();
	}

	MeshBuf* GetParent(void) { return Parent; }
	const MeshBuf* GetParent(void) const { return Parent; }

	void SetTextureUnit(TextureType type, gl::GlTexture* tex);

	bool HasActiveColorTexture(void) const;
	bool HasActiveNormalTexture(void) const;

	gl::GlTexture* GetTexColor(void) { return TexColor; }
	gl::GlTexture* GetTexNormal(void) { return TexNormal; }
	gl::MatcapImage& GetTexMatcap(void) { return TexMatcap; }

	gl::GlTexture* TakeTexture(TextureType type);
	bool IsChild(const gl::GlTexture* tex) const;

private:
	bool IsActiveTexture(gl::GlTexture* tex) const;

public:
	gl::GlTexture* TexColor;
	gl::GlTexture* TexNormal;
	gl::MatcapImage TexMatcap;

private:
	MeshBuf* Parent;
};


}
