#pragma once

#include <LibGeo/Mesh/BaseMesh.h>
#include <LibGeo/CrossSection.h>

#include <C2/graph/Material.h>
#include <C2/lm/Matrix4.h>

#include <vector>
#include <map>

#include "Image/GeomTexture.h"

#include "Transform.h"
#include "PolylineContext.h"

#include "GeomFileFormat.h"
#include "GeoNodeTree.h"
#include "MeshBuf.h"

#include "Skining/SkinWeight.h"



namespace geom
{


class GeomObject
{
public:
	GeomObject(void);
	virtual ~GeomObject(void) {}

	void ClearObject(void);

	const lm::range3f GetGeomBBox(bool for_ini) const;

	bool IsFileObject(void) const;

	void InitializeBufferCommon(void);

	MeshBuf* CreateNewMeshBuf(void);

	size_t GetNumTotalVerts(void) const;
	size_t GetNumTotalFaces(void) const;

	bool IsInChild(const MeshBuf* mbuf) const;

	void SetObjectIndex(int idx)
	{
		m_ObjectIndex = idx;
	}

	int GetObjectIndex(void) const
	{
		return m_ObjectIndex;
	}

	void SetFrameShape(int frame);

	void ResetSmoothNormal(void);

	bool HasMeshes(void) const;

	void InitAllBBox(void);

	void UpdateBoneToNodeLink(SceneNode* sn);

private:
	void ApplyTrans(SceneNode& n, const lm::matrix4f& trans, int a_frame);

public:
	// eReił̃IuWFNg̃CfbNX
	int m_ObjectIndex;

	std::string m_Name;

	// t@CꂽIuWFNg̃\[X
	std::string m_FilePath;
	geom::GeomFileFormat m_FileFormat;

	bool m_Visible;
	bool m_VertexOnlyMode;

	boost::ptr_vector<MeshBuf> m_MeshAry;
	GeoNodeTree m_GTree;

	TextureLib m_TextureLib;
};


}
