#include "stdafx.h"
#include "StlLoader.h"

#include "../FileUtil.h"

#include <LibGeo/Mesh/STL/StlMesh.h>

#include <LibQtGeoViewerCore/SceneMain.h>



GeomObject* StlLoader::LoadGeom(SceneMain& scene, const std::string& filename)
{
	GeomObject* geom = new GeomObject();
	MeshBuf* mbuf = geom->CreateNewMeshBuf();
	lib_geo::BaseMesh& mesh_dst = mbuf->m_Mesh;

	lib_geo::StlMesh stl_mesh;
	if (stl_mesh.Load(filename))
	{
		stl_mesh.ConvertToBaseMesh(mesh_dst);
	}

	if (stl_mesh.ExistZeroLengthNormal())
	{
		mesh_dst.CreateNormalsEachVerts(true);
	}

	geom->m_Name = FileUtil::GetFileTitle(filename);

	geom->m_FileFormat = GeomFileFormat::Stl;
	geom->m_FilePath = filename;
	geom->InitializeBufferCommon();

	return geom;
}
