#include "stdafx.h"
#include "Plyloader.h"

#include "PlyMesh.h"

#include <LibQtGeoViewerCore/SceneMain.h>

#include "../FileUtil.h"



GeomObject* PlyLoader::LoadGeom(SceneMain& scene, const std::string& filename)
{
	lib_geo::ply::PlyMesh ply_mesh;
	if (!ply_mesh.Load(filename))
		return NULL;

	GeomObject* geom = new GeomObject();
	MeshBuf* mbuf = geom->CreateNewMeshBuf();

	lib_geo::BaseMesh& mesh_dst = mbuf->m_Mesh;

	ply_mesh.ConvertToBaseMesh(mesh_dst);

	mesh_dst.CreateNormalsEachVerts(true);

	geom->m_Name = FileUtil::GetFileTitle(filename);

	geom->m_FileFormat = GeomFileFormat::Ply;
	geom->m_FilePath = filename;
	geom->InitializeBufferCommon();

	return geom;
}
