import os
from IOUtil import *

def copyQtLib(Release, SrcDir, OutDir, name):
	srcfile = SrcDir + name
	if not Release:
		srcfile += 'd'
	srcfile += ".dll"
	copyFiles(srcfile, OutDir)

def copyTranslation(SrcDir, OutDir, language):
	srcfile = SrcDir + 'qt_' + language + '.qm'
	copyFiles(srcfile, OutDir)

def copyQtLibsMain(OutDir, release):
	Qt5Dir = os.environ.get("QTDIR")
	Qt_Bin = Qt5Dir + '/bin/'
	createPathIfnotExist(OutDir)
	createPathIfnotExist(OutDir + 'platforms/')
	createPathIfnotExist(OutDir + 'imageformats/')
	createPathIfnotExist(OutDir + 'translations/')
	copyQtLib(release, Qt5Dir + '/plugins/platforms/', OutDir + 'platforms/', 'qwindows')
	copyQtLib(release, Qt5Dir + '/plugins/imageformats/', OutDir + 'imageformats/', 'qjpeg')
	copyTranslation(Qt5Dir + '/translations/', OutDir + 'translations/', 'ja')

def copyQtLibs(OutDir):
	copyQtLibsMain(OutDir, True)

def copyQtLibsD(OutDir):
	copyQtLibsMain(OutDir, False)
