#pragma once

#include <C2/gl/GlDisplayList.h>


class LazyDisp
{
public:
	enum State
	{
		None,
		Called,
		BeginList,
	};

public:
	LazyDisp(lib_gl::GlDisplayList& disp)
	{
		m_Disp = &disp;
		m_State = None;
	}

	virtual ~LazyDisp(void)
	{
		if (m_State == BeginList)
			m_Disp->EndList();
	}

	State CallOrBeginList(void)
	{
		assert(m_State == None);
		if (m_State != None)
			throw std::exception("LazyDisp::CallOrBeginList must not call twice");

		if (m_Disp->IsEnable())
		{
			m_Disp->CallList();

			m_State = Called;
			return Called;
		}

		m_Disp->GenerateList();
		m_Disp->BeginCompieAndExecute();

		m_State = BeginList;
		return BeginList;
	}

private:
	lib_gl::GlDisplayList* m_Disp;
	State m_State;
};
